/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Log;
import com.gameofwhales.sdk.util.GowLruCache;

public class CacheManager {
    private static final String TAG = "GOW.CacheManager";
    private static GowLruCache<String, Bitmap> mMemoryCache;

    public static void Init() {
        try {
            int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
            int cacheSize = maxMemory / 8;
            mMemoryCache = new GowLruCache<String, Bitmap>(cacheSize){

                @Override
                protected int sizeOf(String key, Bitmap bitmap) {
                    return bitmap.getByteCount() / 1024;
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Resize(String url) {
        try {
            Bitmap original = CacheManager.GetBitmap(url);
            if (original == null) {
                return;
            }
            int width = original.getWidth();
            int height = original.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale(0.5f, 0.5f);
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)original, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
            mMemoryCache.put(url, resizedBitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void AddBitmap(Bitmap bitmap, String key) {
        try {
            if (CacheManager.IsBitmapExists(key)) {
                Log.e((String)TAG, (String)("Bitmap already exists: key: " + key));
                return;
            }
            mMemoryCache.put(key, bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap GetBitmap(String key) {
        try {
            return mMemoryCache.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean IsBitmapExists(String key) {
        try {
            return mMemoryCache.get(key) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

