/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Adv {
    private static int width = 0;
    private static int height = 0;
    private static final String TAG = "GOW.ADS";
    private String camp;
    private String url;
    private Date finishedAt;
    private Date lastShowTime;
    private int showFrequencyInMinutes;
    private long showFrequencyInMilliseconds;
    private String title;
    private String message;
    private boolean _isPortraitLoaded = false;
    private boolean _isLandscapeLoaded = false;
    private String portrait_image;
    private String landscape_image;
    private int loadCount = 0;
    private int showCount = 0;

    public Adv(JSONObject json) {
        try {
            this.camp = json.getString("camp");
            this.finishedAt = new Date(json.getLong("finishedAt"));
            this.url = json.getString("url");
            this.showFrequencyInMinutes = json.getInt("showFrequencyInMinutes");
            this.showFrequencyInMilliseconds = this.showFrequencyInMinutes * 60 * 1000;
            JSONObject content = json.getJSONObject("content");
            JSONArray portraitArray = content.getJSONArray("portrait");
            this.portrait_image = this.FindBestImage(portraitArray, width, height);
            JSONArray landscaleArray = content.getJSONArray("landscape");
            this.landscape_image = this.FindBestImage(landscaleArray, height, width);
        }
        catch (JSONException e) {
            L.e(TAG, e.getMessage());
        }
        L.e(TAG, "");
    }

    public void IncLoadCount() {
        ++this.loadCount;
    }

    public int GetLoadCount() {
        return this.loadCount;
    }

    public int GetShowCount() {
        return this.showCount;
    }

    public boolean HasPortraitImage() {
        return this.portrait_image != null && !this.portrait_image.isEmpty();
    }

    public boolean HasLandscapeImage() {
        return this.landscape_image != null && !this.landscape_image.isEmpty();
    }

    private String FindBestImage(JSONArray array, int width, int height) throws JSONException {
        String result = "";
        try {
            float ratio_diff = 10000.0f;
            float resolution_diff = 100000.0f;
            float ratio = (float)width / ((float)height * 1.0f);
            for (int i = 0; i < array.length(); ++i) {
                boolean better = false;
                JSONObject metaImage = array.getJSONObject(i);
                int w = metaImage.getInt("width");
                int h = metaImage.getInt("height");
                float cur_ratio_diff = Math.abs(ratio - (float)w / ((float)h * 1.0f));
                float cur_resolution_diff = Math.abs(width - w) + Math.abs(height - h);
                String imgUrl = metaImage.getString("url");
                if (result.isEmpty()) {
                    better = true;
                }
                if (cur_ratio_diff < ratio_diff) {
                    better = true;
                }
                if (Math.abs(ratio_diff - cur_ratio_diff) < 0.1f && cur_resolution_diff < resolution_diff) {
                    better = true;
                }
                if (!better) continue;
                ratio_diff = cur_ratio_diff;
                resolution_diff = cur_resolution_diff;
                result = imgUrl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String GetCamp() {
        return this.camp;
    }

    public void SetPortraitLoaded() {
        this._isPortraitLoaded = true;
    }

    public void SetLandscapeLoaded() {
        this._isLandscapeLoaded = true;
    }

    public boolean IsLoaded() {
        return this._isPortraitLoaded || this._isLandscapeLoaded;
    }

    public void SetShowed() {
        ++this.showCount;
        this.lastShowTime = new Date(GameOfWhales.GetServerTime());
    }

    public long GetLeftTime() {
        if (this.finishedAt == null) {
            return -1L;
        }
        return this.finishedAt.getTime() - GameOfWhales.GetServerTime();
    }

    public long GetDelayTime() {
        try {
            if (this.lastShowTime == null) {
                return 0L;
            }
            long diff = GameOfWhales.GetServerTime() - this.lastShowTime.getTime();
            return GameOfWhales.GetServerTime() - this.lastShowTime.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public boolean CanShow() {
        try {
            long left = this.GetLeftTime();
            long delay = this.GetDelayTime();
            return this.GetLeftTime() > 0L && (this.lastShowTime == null || this.GetDelayTime() > this.showFrequencyInMilliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int GetShowFrequency() {
        return this.showFrequencyInMinutes;
    }

    public String GetTitle() {
        return this.title;
    }

    public String GetMessage() {
        return this.message;
    }

    public String GetPortraitImage() {
        return this.portrait_image;
    }

    public String GetLandscapeImage() {
        return this.landscape_image;
    }

    public String getId() {
        if (this.camp == null) {
            return "";
        }
        return this.camp;
    }

    public String GetUrl() {
        return this.url;
    }

    public Date getFinishedAt() {
        if (this.finishedAt == null) {
            return new Date(0L);
        }
        return this.finishedAt;
    }

    public long getLeftTime() {
        try {
            if (this.finishedAt == null) {
                return -1L;
            }
            return this.finishedAt.getTime() - GameOfWhales.GetServerTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static void SetResolution(int width, int height) {
        Adv.width = width;
        Adv.height = height;
        Log.i((String)TAG, (String)("Adv resolution: " + width + "x" + height));
    }
}

