/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import com.gameofwhales.sdk.CommandQueue;
import com.gameofwhales.sdk.Experiment;
import com.gameofwhales.sdk.GameOfWhalesListener;
import com.gameofwhales.sdk.InternalSystem;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.LandscapePromoActivity;
import com.gameofwhales.sdk.PortraitPromoActivity;
import com.gameofwhales.sdk.SpecialOffer;
import com.gameofwhales.sdk.async.AdverstingIDAsyncTask;
import com.gameofwhales.sdk.async.AdverstingIDAsyncTaskListener;
import com.gameofwhales.sdk.async.FetchBitmapAsync;
import com.gameofwhales.sdk.async.FetchBitmapAsyncListener;
import com.gameofwhales.sdk.broadcast.GOWBroadcast;
import com.gameofwhales.sdk.protocol.Product;
import com.gameofwhales.sdk.protocol.SpecialOfferData;
import com.gameofwhales.sdk.protocol.commands.AdvActionCommand;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.ConvertingCommand;
import com.gameofwhales.sdk.protocol.commands.ErrorCommand;
import com.gameofwhales.sdk.protocol.commands.ExtAdActionCommand;
import com.gameofwhales.sdk.protocol.commands.ExternalIDCommand;
import com.gameofwhales.sdk.protocol.commands.InstallReferrerCommand;
import com.gameofwhales.sdk.protocol.commands.LoginCommand;
import com.gameofwhales.sdk.protocol.commands.ProfileCommand;
import com.gameofwhales.sdk.protocol.commands.PurchaseCommand;
import com.gameofwhales.sdk.protocol.commands.PushDeliveredCommand;
import com.gameofwhales.sdk.protocol.commands.PushReactedCommand;
import com.gameofwhales.sdk.protocol.commands.ReceiptCommand;
import com.gameofwhales.sdk.protocol.commands.TokenCommand;
import com.gameofwhales.sdk.util.ActivityLyfecycleListener;
import com.gameofwhales.sdk.util.Adv;
import com.gameofwhales.sdk.util.BitmapData;
import com.gameofwhales.sdk.util.CacheManager;
import com.gameofwhales.sdk.util.CommandListener;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.DelayedNofification;
import com.gameofwhales.sdk.util.GOWGCMService;
import com.gameofwhales.sdk.util.RequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GameOfWhales {
    public static String platform = "android";
    public static String VERSION;
    private static final String VERSION_SDK;
    public static final String CAMPAIGN_ID = "camp";
    public static final String PUSH_GOW = "gowpush";
    private static final String TAG = "GameOfWhales";
    public static final String STORE_SAMSUNG = "SamsungApps";
    public static final String STORE_GOOGLEPLAY = "GooglePlay";
    public static final String STORE_AMAZON = "AmazonStore";
    public static final String STORE_FACEBOOK = "Facebook";
    public static final String PROVIDER_FCM = "fcm";
    public static final String PROVIDER_GCM = "gcm";
    public static final String EXTERNAL_ID_APPSFLYER = "appsflyer";
    public static final String VERIFY_STATE_LEGAL = "legal";
    public static final String VERIFY_STATE_ILLEGAL = "illegal";
    public static final String VERIFY_STATE_UNDEFINED = "undefined";
    public static final String INTENT_ANDROID_ID = "androidID";
    private static final int BATCHING_DELAY = 30000;
    private static GameOfWhales INSTANCE;
    private final Activity activity;
    private CommandQueue queue;
    private Set<String> segments = new HashSet<String>();
    private Set<GameOfWhalesListener> listeners = new HashSet<GameOfWhalesListener>();
    private Map<String, Product> products = new HashMap<String, Product>();
    private Map<String, Adv> advs = new HashMap<String, Adv>();
    private List<SpecialOfferData> specialOfferData = new ArrayList<SpecialOfferData>();
    private Map<String, SpecialOffer> activeOffers = new HashMap<String, SpecialOffer>();
    private Map<String, SpecialOffer> futureOffers = new HashMap<String, SpecialOffer>();
    private JSONObject properties = new JSONObject();
    private DataStorage data;
    private ActivityLyfecycleListener cycleListener;
    private Handler batchingHandler = new Handler();
    private Intent lastIntent;
    private List<DelayedNofification> delayedNofifications = new ArrayList<DelayedNofification>();
    private long serverTime = 0L;
    private long serverTimeDT = 0L;
    private int baseOrientation = 1;
    private boolean canDelayExperimentStart = false;
    private Experiment delayedExperiment = null;
    private CommandListener commandListener = new CommandListener(){

        @Override
        public void onCommandResponse(Command command, JSONObject response) {
            GameOfWhales.this.onCommandResponse(command, response);
        }
    };
    long _lastBatchTime = 0L;
    private Runnable updateRunner = new Runnable(){

        @Override
        public void run() {
            try {
                if (GameOfWhales.this.check("updateRunner run")) {
                    return;
                }
                long current = GameOfWhales.GetServerTime();
                if (current - GameOfWhales.this._lastBatchTime > 30000L) {
                    GameOfWhales.this._lastBatchTime = current;
                    GameOfWhales.this.queue.tryToSendNext(false);
                }
                boolean offersChanged = false;
                Iterator it = GameOfWhales.this.activeOffers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    SpecialOffer rep = (SpecialOffer)entry.getValue();
                    if (rep == null) {
                        L.e(GameOfWhales.TAG, "rep is null from: updateRunner");
                        continue;
                    }
                    if (!rep.isExpired()) continue;
                    offersChanged = true;
                    it.remove();
                    GameOfWhales.this.onDisappeared(rep);
                }
                if (offersChanged) {
                    GameOfWhales.this.updateSpecialOffers();
                }
                ArrayList<String> future_removed = new ArrayList<String>();
                for (Map.Entry entry : GameOfWhales.this.futureOffers.entrySet()) {
                    SpecialOffer offer = (SpecialOffer)entry.getValue();
                    if (!offer.isActivated()) continue;
                    future_removed.add(offer.product);
                    offersChanged = true;
                }
                for (String product : future_removed) {
                    GameOfWhales.this.futureOffers.remove(product);
                }
                if (offersChanged) {
                    GameOfWhales.this.updateSpecialOffers();
                }
                GameOfWhales.this.runUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private GameOfWhales(Activity activity, String gameID, String store, GameOfWhalesListener listener, boolean nonPersonal) {
        this.activity = activity;
        try {
            Log.i((String)TAG, (String)("Initializing GameOfWhales [" + VERSION_SDK + " android / " + VERSION + " " + platform + "]"));
            Log.i((String)TAG, (String)("with: gameID:" + gameID + "  store:" + store + "  nonPersonal: " + nonPersonal));
            RequestBuilder.LOCALE = activity.getResources().getConfiguration().locale.getISO3Language();
            RequestBuilder.app_version = this.GetAppVersion();
            CacheManager.Init();
            this.data = new DataStorage((Context)activity, gameID, store);
            this.data.SetPlatform(platform);
            this.data.SetVersion(VERSION);
            InternalSystem.Init(this.data);
            this.baseOrientation = activity.getResources().getConfiguration().orientation;
            this.queue = new CommandQueue(activity, this.data, this.commandListener);
            this.cycleListener = new ActivityLyfecycleListener();
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.cycleListener);
            this.login();
            if (listener != null) {
                this.addListener(listener);
            }
            if (this.data.getAdvID().isEmpty()) {
                if (nonPersonal) {
                    this.data.setAdvID(GameOfWhales.GenUniqID());
                    this.queue.tryToSendNext(false);
                    this.InitComplete();
                } else {
                    AdverstingIDAsyncTask advTask = new AdverstingIDAsyncTask((Context)activity, new AdverstingIDAsyncTaskListener(){

                        @Override
                        public void onSuccess(String id2) {
                            if (GameOfWhales.this.check("AdverstingIDAsyncTask onSuccess")) {
                                return;
                            }
                            GameOfWhales.this.data.setAdvID(id2);
                            GameOfWhales.this.queue.tryToSendNext(false);
                            GameOfWhales.this.InitComplete();
                        }

                        @Override
                        public void onFailure() {
                            if (GameOfWhales.this.check("AdverstingIDAsyncTask onFailure")) {
                                return;
                            }
                            GameOfWhales.this.data.setAdvID(GameOfWhales.GenUniqID());
                            GameOfWhales.this.queue.tryToSendNext(false);
                            GameOfWhales.this.InitComplete();
                        }
                    });
                    if (Build.VERSION.SDK_INT >= 11) {
                        advTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                    } else {
                        advTask.execute(new Void[0]);
                    }
                }
            } else {
                this.InitComplete();
            }
            GameOfWhales.UpdateScreenResolution((Context)activity);
            this.runUpdate();
            this.data.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sendInstallReferrerData(this.data);
    }

    public void setCanExperimentStartDelay(boolean value) {
        this.canDelayExperimentStart = value;
    }

    public void setDelayedExperimentStartAnswer(boolean value) {
        try {
            if (this.delayedExperiment == null) {
                Log.e((String)TAG, (String)"setDelayedExperimentStartAnswer: delayedExperiment is null");
                return;
            }
            L.i(TAG, "setDelayedExperimentStartAnswer: " + value);
            this.setCanExperimentStartAnswer(value, this.delayedExperiment);
            this.delayedExperiment = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCanExperimentStartAnswer(boolean value, Experiment experiment) {
        try {
            L.i(TAG, "setCanExperimentStartAnswer: " + value + " for experiment with ID: " + experiment.id);
            if (value) {
                this.data.SetExperiment(experiment);
            } else {
                this.data.SetExperimentIgnored(experiment.id);
            }
            this.queue.tryToSendNext(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String GenUniqID() {
        String id2 = "gen-android-" + UUID.randomUUID().toString();
        return id2;
    }

    public boolean IsPushWasShown(String camp) {
        return this.data.IsPushShown(camp);
    }

    public void SetPushShown(String camp) {
        this.data.SetPushShown(camp);
    }

    public static boolean IsPushNotificationEnabled() {
        if (GameOfWhales.instanceCheck("IsPushNotificationEnabled")) {
            return INSTANCE.isPushNotificationEnabled();
        }
        return false;
    }

    public boolean isPushNotificationEnabled() {
        return this.data.isNotificationsEnable();
    }

    public static void SetPushNotificationsEnable(boolean value) {
        if (GameOfWhales.instanceCheck("SetPushNotificationsEnable")) {
            INSTANCE.setPushNotificationsEnable(value);
        }
    }

    public int getBaseOrientation() {
        return this.baseOrientation;
    }

    public void setPushNotificationsEnable(boolean value) {
        try {
            if (value == this.data.isNotificationsEnable()) {
                return;
            }
            this.data.setNotificationsEnable(value);
            if (value) {
                this.updateToken(this.data.getToken(), this.data.getProvider());
            } else {
                this.updateToken("", PROVIDER_GCM);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static GameOfWhales getInstance() {
        return INSTANCE;
    }

    void InitComplete() {
        try {
            if (this.check("InitComplete")) {
                return;
            }
            GOWBroadcast.BroadcastSDKInitFinish((Context)this.activity);
            this.readIntent();
            this.queue.tryToSendNext(false);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    GameOfWhales.this.onInitialized();
                }
            }, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void login() {
        try {
            if (this.check("login")) {
                return;
            }
            this.queue.add(new LoginCommand());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Product getProduct(String sku) {
        try {
            if (this.check("getProduct")) {
                return null;
            }
            if (!this.products.containsKey(sku)) {
                this.products.put(sku, new Product(sku));
            }
            return this.products.get(sku);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean instanceCheck(String from) {
        if (INSTANCE == null) {
            L.e(TAG, from + ": GameOfWhales not initialized");
            return false;
        }
        return true;
    }

    public void pushDelivered(final String campID) {
        try {
            if (this.check("pushDelivered")) {
                return;
            }
            if (campID == null || campID.isEmpty()) {
                return;
            }
            if (this.data.IsCampExists(campID, "push_delivered")) {
                L.w(TAG, "Push was already delivered: '" + campID + "'");
                return;
            }
            this.data.AddCamp(campID, "push_delivered");
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PushDeliveredCommand command = new PushDeliveredCommand(campID);
                    GameOfWhales.this.queue.add(command);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void PushDelivered(String campID) {
        if (GameOfWhales.instanceCheck("PushDelivered")) {
            INSTANCE.pushDelivered(campID);
        }
    }

    public void AdEvent(final String camp, final String action) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AdvActionCommand cmd = new AdvActionCommand(camp, action);
                        GameOfWhales.this.queue.add(cmd);
                        if (action.equals("clicked")) {
                            GameOfWhales.this.data.AddCamp(camp, "promoad_clicked");
                            GameOfWhales.this.advs.remove(camp);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pushReacted(final String campID) {
        try {
            if (this.check("pushReacted")) {
                return;
            }
            if (campID == null || campID.isEmpty()) {
                return;
            }
            if (this.data.IsCampExists(campID, "push_reacted")) {
                L.w(TAG, "Push was already reacted: '" + campID + "'");
                return;
            }
            this.data.AddCamp(campID, "push_reacted");
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PushReactedCommand command = new PushReactedCommand(campID);
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void PushReacted(String campID) {
        if (GameOfWhales.instanceCheck("PushReacted")) {
            INSTANCE.pushReacted(campID);
        }
    }

    public static void UpdateToken(String token, String provider) {
        if (GameOfWhales.instanceCheck("UpdateToken")) {
            INSTANCE.updateToken(token, provider);
        }
    }

    public static void ReportError(String message, String stacktrace) {
        if (GameOfWhales.instanceCheck("ReportError")) {
            INSTANCE.reportError(message, stacktrace);
        }
    }

    public static JSONObject GetProperties() {
        if (GameOfWhales.instanceCheck("GetProperties")) {
            return INSTANCE.getProperties();
        }
        return null;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public static String GetUserGroup() {
        if (GameOfWhales.instanceCheck("GetUserGroup")) {
            return INSTANCE.getUserGroup();
        }
        return "";
    }

    public String getUserGroup() {
        try {
            if (this.properties == null) {
                return "";
            }
            String id2 = "group";
            if (!this.properties.has("group")) {
                return "";
            }
            return this.properties.getString("group");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void reportError(final String message, final String stacktrace) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ErrorCommand command = new ErrorCommand(message, stacktrace);
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String GetAppVersion() {
        try {
            PackageManager m = this.activity.getPackageManager();
            String app_ver = "";
            try {
                app_ver = m.getPackageInfo((String)this.activity.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            return app_ver;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void DetailsReceived(Bundle data) {
        if (GameOfWhales.instanceCheck("DetailsReceived")) {
            INSTANCE.detailsReceived(data);
        }
    }

    public static boolean IsSdkInitalized() {
        try {
            if (INSTANCE == null) {
                return false;
            }
            return GameOfWhales.INSTANCE.data.isReady();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean IsAppForeground() {
        try {
            if (INSTANCE == null) {
                return false;
            }
            if (GameOfWhales.INSTANCE.cycleListener == null) {
                return false;
            }
            return GameOfWhales.INSTANCE.cycleListener.isForeground();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Experiment GetCurrentExperiment() {
        if (GameOfWhales.instanceCheck("GetCurrentExperiment")) {
            return INSTANCE.getCurrentExperiment();
        }
        return null;
    }

    public Experiment getCurrentExperiment() {
        return this.data.GetExperiment();
    }

    public static GameOfWhales Init(Activity activity, String gameID, String store, GameOfWhalesListener listener) {
        try {
            INSTANCE = new GameOfWhales(activity, gameID, store, listener, false);
            return INSTANCE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GameOfWhales Init(Activity activity, String gameID, String store, GameOfWhalesListener listener, boolean nonPersonal) {
        try {
            INSTANCE = new GameOfWhales(activity, gameID, store, listener, nonPersonal);
            return INSTANCE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GameOfWhales Init(Activity activity, String store, GameOfWhalesListener listener) {
        try {
            INSTANCE = new GameOfWhales(activity, null, store, listener, false);
            return INSTANCE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GameOfWhales Init(Activity activity, String store, GameOfWhalesListener listener, boolean nonPersonal) {
        try {
            INSTANCE = new GameOfWhales(activity, null, store, listener, nonPersonal);
            return INSTANCE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addListener(GameOfWhalesListener listener) {
        try {
            if (this.listeners == null) {
                L.e(TAG, "Listeners is null from: addListener");
                return;
            }
            this.listeners.add(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeListener(GameOfWhalesListener listener) {
        try {
            if (this.listeners == null) {
                L.e(TAG, "Listeners is null from: removeListener");
                return;
            }
            this.listeners.remove(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long GetServerTime() {
        if (GameOfWhales.instanceCheck("GetServerTime")) {
            return INSTANCE.getServerTime();
        }
        return 0L;
    }

    public long getServerTime() {
        try {
            if (this.serverTime == 0L) {
                return 0L;
            }
            return this.serverTime + (System.currentTimeMillis() - this.serverTimeDT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private void readServerTime(JSONObject object) throws Exception {
        try {
            if (object == null) {
                return;
            }
            String id2 = "serverTime";
            L.i(TAG, "Reading server time");
            this.serverTime = object.getLong("serverTime");
            this.serverTimeDT = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readAds(JSONObject object) throws Exception {
        try {
            if (object == null) {
                return;
            }
            String id2 = "ads";
            if (!object.has("ads")) {
                return;
            }
            JSONArray array = object.getJSONArray("ads");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject jsonAd = array.getJSONObject(i);
                try {
                    Adv adv = new Adv(jsonAd);
                    if (this.data.IsCampExists(adv.GetCamp(), "promoad_clicked") || this.advs.containsKey(adv.getId())) continue;
                    this.advs.put(adv.getId(), adv);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readProperties(JSONObject object) throws Exception {
        try {
            if (object == null) {
                return;
            }
            String id2 = "properties";
            if (!object.has("properties")) {
                return;
            }
            L.i(TAG, "Reading properties");
            this.properties = object.getJSONObject("properties");
            GOWBroadcast.BroadcastUserStatus((Context)this.activity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readExperiment(JSONObject object) throws Exception {
        try {
            if (object == null) {
                return;
            }
            String id2 = "experiment";
            Log.i((String)TAG, (String)"readExperiment");
            if (!object.has("experiment")) {
                Log.i((String)TAG, (String)"readExperiment: is null");
                this.UpdateExperiment(null);
                return;
            }
            Log.i((String)TAG, (String)"readExperiment: not null");
            JSONObject expJson = object.getJSONObject("experiment");
            Experiment experiment = new Experiment(expJson);
            this.UpdateExperiment(experiment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void UpdateExperiment(Experiment experiment) {
        try {
            if (this.delayedExperiment != null) {
                Log.i((String)TAG, (String)("Won't update experiment, waiting for answer: " + this.delayedExperiment.id));
                return;
            }
            if (this.data.HasExperiment()) {
                if (experiment != null && this.data.IsExperimentIgnored(experiment.id)) {
                    return;
                }
                if (experiment == null || !this.data.IsExperiment(experiment.id)) {
                    this.onExperimentEnded(this.data.GetExperiment());
                    this.data.SetExperiment(null);
                    this.data.SetExperimentIgnored(null);
                    this.UpdateExperiment(experiment);
                    return;
                }
            } else {
                if (experiment == null || this.data.IsExperimentIgnored(experiment.id)) {
                    return;
                }
                if (this.canDelayExperimentStart) {
                    if (this.delayedExperiment == null) {
                        this.delayedExperiment = experiment;
                        this.CanStartExperiment(experiment);
                        return;
                    }
                } else {
                    this.setCanExperimentStartAnswer(this.CanStartExperiment(experiment), experiment);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readSpecialOffers(JSONObject object) throws Exception {
        try {
            if (object == null) {
                return;
            }
            String id2 = "specialOffers";
            if (!object.has("specialOffers")) {
                return;
            }
            L.i(TAG, "Reading special offers");
            JSONArray array = object.getJSONArray("specialOffers");
            this.specialOfferData.clear();
            for (int i = 0; i < array.length(); ++i) {
                JSONObject jsonSO = array.getJSONObject(i);
                SpecialOfferData so = new SpecialOfferData(jsonSO);
                this.specialOfferData.add(so);
            }
            String fid = "futureOffers";
            if (object.has("futureOffers")) {
                L.i(TAG, "Reading future offers");
                JSONArray farray = object.getJSONArray("futureOffers");
                for (int i = 0; i < farray.length(); ++i) {
                    JSONObject jsonSO = farray.getJSONObject(i);
                    SpecialOfferData so = new SpecialOfferData(jsonSO);
                    this.specialOfferData.add(so);
                }
            }
            this.updateSpecialOffers();
            this.checkDelayedNotifications();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasSpecialOffer(String productID) {
        try {
            if (this.check("hasSpecialOffer")) {
                return false;
            }
            return this.activeOffers.get(productID) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    SpecialOffer getActiveOfferFor(String product) {
        if (this.check("getActiveOfferFor")) {
            return null;
        }
        return this.activeOffers.get(product);
    }

    SpecialOffer getFutureOfferFor(String product) {
        if (this.check("getFutureOfferFor")) {
            return null;
        }
        return this.futureOffers.get(product);
    }

    SpecialOffer getSpecialOfferByCamp(String camp) {
        try {
            for (Map.Entry<String, SpecialOffer> entry : this.activeOffers.entrySet()) {
                SpecialOffer so = entry.getValue();
                if (!so.campaign.equals(camp)) continue;
                return so;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SpecialOffer createSpecialOffer(SpecialOfferData sod, String product) {
        SpecialOffer offer = null;
        try {
            offer = new SpecialOffer();
            offer.campaign = sod.getId();
            offer.product = product;
            offer.priceFactor = sod.getPriceFactor();
            offer.countFactor = sod.getCountFactor();
            offer.finishedAt = sod.getFinishedAt();
            offer.activatedAt = sod.getActivatedAt();
            offer.payload = sod.getPayload();
            offer.redeemable = sod.isRedeemable();
            offer.customValues = sod.getCustomValues();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return offer;
    }

    void updateSpecialOffers() {
        try {
            SpecialOffer specialOffer;
            if (INSTANCE == null) {
                Log.e((String)TAG, (String)"UpdateOffer: instance is null");
            }
            HashSet<String> appeared = new HashSet<String>();
            ArrayList<String> removed = new ArrayList<String>();
            ArrayList<SpecialOffer> replaced = new ArrayList<SpecialOffer>();
            HashSet<String> future_appeared = new HashSet<String>();
            for (SpecialOfferData specialOfferData : this.specialOfferData) {
                if (specialOfferData == null) continue;
                if (specialOfferData.isExpired()) {
                    L.i(TAG, "updateSpecialOffers: offer is expiried: " + specialOfferData.getId());
                    continue;
                }
                if (this.isSpecialOfferUsed(specialOfferData.getId())) {
                    L.i(TAG, "updateSpecialOffers: offer is already used: " + specialOfferData.getId());
                    continue;
                }
                List<String> products = specialOfferData.getProducts();
                if (specialOfferData.isActivated()) {
                    for (String product : products) {
                        SpecialOffer offer;
                        boolean add;
                        SpecialOffer currentActiveOffer = this.getActiveOfferFor(product);
                        boolean bl = add = currentActiveOffer == null;
                        if (currentActiveOffer != null) {
                            float newValue;
                            float activeValue = currentActiveOffer.priceFactor == 0.0f ? currentActiveOffer.countFactor : currentActiveOffer.countFactor / currentActiveOffer.priceFactor;
                            float f = newValue = specialOfferData.getPriceFactor() == 0.0f ? specialOfferData.getCountFactor() : specialOfferData.getCountFactor() / specialOfferData.getPriceFactor();
                            if (newValue > activeValue || currentActiveOffer.isExpired() || this.isSpecialOfferUsed(currentActiveOffer.campaign)) {
                                add = true;
                            }
                        }
                        if (!add || (offer = this.createSpecialOffer(specialOfferData, product)) == null) continue;
                        if (currentActiveOffer != null) {
                            replaced.add(currentActiveOffer);
                        }
                        this.activeOffers.put(product, offer);
                        appeared.add(product);
                    }
                    continue;
                }
                for (String product : products) {
                    if (future_appeared.contains(product)) {
                        L.i(TAG, "GameOfWhales:updateSpecialOffers: future offer for product already added " + specialOfferData.getId());
                        continue;
                    }
                    if (this.getFutureOfferFor(product) != null) {
                        L.i(TAG, "GameOfWhales:updateSpecialOffers: future offer for product already appeared " + specialOfferData.getId());
                        continue;
                    }
                    SpecialOffer offer = this.createSpecialOffer(specialOfferData, product);
                    future_appeared.add(product);
                    this.futureOffers.put(product, offer);
                }
            }
            for (Map.Entry entry : this.activeOffers.entrySet()) {
                SpecialOffer rep = (SpecialOffer)entry.getValue();
                boolean found = false;
                for (SpecialOfferData so : this.specialOfferData) {
                    if (so.isExpired() || this.isSpecialOfferUsed(so.getId())) continue;
                    for (String product : so.getProducts()) {
                        if (!product.equals(rep.product)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                removed.add(rep.product);
            }
            for (SpecialOffer specialOffer2 : replaced) {
                this.onDisappeared(specialOffer2);
            }
            for (String string2 : removed) {
                specialOffer = this.getActiveOfferFor(string2);
                this.activeOffers.remove(string2);
                this.onDisappeared(specialOffer);
            }
            for (String string3 : appeared) {
                specialOffer = this.getActiveOfferFor(string3);
                this.onAppeared(specialOffer);
            }
            for (String string4 : future_appeared) {
                specialOffer = this.getFutureOfferFor(string4);
                this.onFutureAppeared(specialOffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReport() {
        try {
            if (L.isDebug) {
                StringBuilder b = new StringBuilder();
                b.append("\nReport{");
                b.append(String.format("\n  Game id: %s", this.data.getGameID()));
                b.append(String.format("\n  Player id: %s", this.data.getAdvID()));
                b.append("\n  Segments:{");
                for (String seg : this.segments) {
                    b.append("\n    " + seg);
                }
                b.append("\n  }");
                b.append("\n  SpecialOffers:{");
                for (SpecialOffer rep : this.getSpecialOffers()) {
                    b.append("\n    " + rep.toString());
                }
                b.append("\n  }");
                b.append("\n}");
                L.d(TAG, b.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readVerifyState(JSONObject object) throws Exception {
        try {
            String purchases = "receipts";
            String transactionID = "transaction";
            String verifyState = "verifyState";
            if (!object.has("receipts")) {
                return;
            }
            L.i(TAG, "readVerifyState");
            JSONArray purchasesArray = object.getJSONArray("receipts");
            for (int i = 0; i < purchasesArray.length(); ++i) {
                JSONObject item = purchasesArray.getJSONObject(i);
                String tID = item.getString("transaction");
                String state = item.getString("verifyState");
                this.onPurchaseVerified(tID, state);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void UpdateScreenResolution(Context context) {
        try {
            int width = Resources.getSystem().getDisplayMetrics().widthPixels;
            int height = Resources.getSystem().getDisplayMetrics().heightPixels;
            int dpi = Resources.getSystem().getDisplayMetrics().densityDpi;
            Log.e((String)TAG, (String)("WIDTH: " + width + "  HEIGHT: " + height + "  DPI: " + dpi));
            Adv.SetResolution(width, height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readSegments(JSONObject object) throws Exception {
        try {
            if (object == null) {
                return;
            }
            String id2 = "segments";
            if (!object.has("segments")) {
                return;
            }
            JSONArray array = object.getJSONArray("segments");
            L.i(TAG, "Reading segments");
            this.segments.clear();
            for (int i = 0; i < array.length(); ++i) {
                String segment = array.getString(i);
                this.segments.add(segment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void DetailsFromString(String string2) {
        if (GameOfWhales.instanceCheck("DetailsFromString")) {
            INSTANCE.detailsFromString(string2);
        }
    }

    public void detailsFromString(String string2) {
        try {
            string2 = string2.substring(string2.indexOf("{"));
            JSONObject json = new JSONObject(string2);
            String sku = json.getString("productId");
            Product p = this.getProduct(sku);
            p.setDetails(json);
            this.updateSpecialOffers();
        }
        catch (Exception e) {
            L.e(TAG, "detailsFromString Exception");
            e.printStackTrace();
            return;
        }
    }

    public void detailsReceived(final Bundle data) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (GameOfWhales.this.check("detailsReceived")) {
                        return;
                    }
                    try {
                        int response = data.getInt("RESPONSE_CODE");
                        if (response != 0) {
                            L.e(GameOfWhales.TAG, "Query product error with response code " + response);
                            return;
                        }
                        ArrayList responseList = data.getStringArrayList("DETAILS_LIST");
                        for (String item : responseList) {
                            JSONObject json = new JSONObject(item);
                            String sku = json.getString("productId");
                            Product p = GameOfWhales.this.getProduct(sku);
                            p.setDetails(json);
                        }
                        GameOfWhales.this.updateSpecialOffers();
                    }
                    catch (Exception e) {
                        L.e(GameOfWhales.TAG, "detailsReceived Exception");
                        e.printStackTrace();
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Purchase(String product, String currency, double price, String transactionID, String receipt, boolean verify) {
        if (GameOfWhales.instanceCheck("Purchase(full args)")) {
            INSTANCE.purchase(product, currency, price, transactionID, receipt, verify);
        }
    }

    public void purchase(final String product, final String currency, final double price, final String transactionID, final String receipt, final boolean verify) {
        if (this.check("purchase")) {
            return;
        }
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PurchaseCommand purchaseCommand = new PurchaseCommand(product, currency, GameOfWhales.this.data.getStore(), price);
                    purchaseCommand.SetReceipt(receipt);
                    purchaseCommand.SetTransactionID(transactionID);
                    purchaseCommand.SetVerify(verify);
                    SpecialOffer offer = GameOfWhales.this.getSpecialOffer(product);
                    if (offer != null) {
                        GameOfWhales.this.saveUsedSpecialOffer(offer);
                        purchaseCommand.setCampaign(offer.campaign);
                        GameOfWhales.this.updateSpecialOffers();
                    }
                    GameOfWhales.this.queue.add(purchaseCommand);
                    GameOfWhales.this.queue.tryToSendNext(false);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Purchase(String product, String currency, double price) {
        if (GameOfWhales.instanceCheck("Purchase(No verify)")) {
            INSTANCE.purchase(product, currency, price);
        }
    }

    public void purchase(final String product, final String currency, final double price) {
        if (this.check("purchase")) {
            return;
        }
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PurchaseCommand purchaseCommand = new PurchaseCommand(product, currency, GameOfWhales.this.data.getStore(), price);
                    SpecialOffer offer = GameOfWhales.this.getSpecialOffer(product);
                    if (offer != null) {
                        GameOfWhales.this.saveUsedSpecialOffer(offer);
                        purchaseCommand.setCampaign(offer.campaign);
                        GameOfWhales.this.updateSpecialOffers();
                    }
                    GameOfWhales.this.queue.add(purchaseCommand);
                    GameOfWhales.this.queue.tryToSendNext(false);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void InAppPurchased(String sku, double price, String currency, String transactionId, String receipt) {
        if (GameOfWhales.instanceCheck("InAppPurchased(full args)")) {
            INSTANCE.inAppPurchased(sku, price, currency, transactionId, receipt);
        }
    }

    public void inAppPurchased(final String sku, final double price, final String currency, final String transactionId, final String receipt) {
        if (this.check("inAppPurchased")) {
            return;
        }
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReceiptCommand receiptCommand = new ReceiptCommand(transactionId, receipt.toString());
                        SpecialOffer offer = GameOfWhales.this.getSpecialOffer(sku);
                        if (offer != null) {
                            GameOfWhales.this.saveUsedSpecialOffer(offer);
                            receiptCommand.setCampaign(offer.campaign);
                            GameOfWhales.this.updateSpecialOffers();
                        }
                        receiptCommand.setPrice(price * 100.0);
                        receiptCommand.setCurrency(currency);
                        GameOfWhales.this.queue.add(receiptCommand);
                        GameOfWhales.this.queue.tryToSendNext(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void SetAndroidProjectID(String id2) {
        if (GameOfWhales.instanceCheck("SetAndroidProjectID")) {
            INSTANCE.setAndroidProjectID(id2);
        }
    }

    public void setAndroidProjectID(String id2) {
        try {
            if (id2 == null || id2.isEmpty()) {
                return;
            }
            L.i(TAG, "setAndroidProjectID: " + id2);
            Intent intent = new Intent((Context)this.activity, GOWGCMService.class);
            intent.putExtra(INTENT_ANDROID_ID, id2);
            this.activity.startService(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Acquire(String currency, long amount, String source, long number, String place) {
        if (GameOfWhales.instanceCheck("Acquire")) {
            INSTANCE.acquire(currency, amount, source, number, place);
        }
    }

    public void acquire(final String currency, final long amount, final String source, final long number, final String place) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap<String, Long> resources = new HashMap<String, Long>();
                        resources.put(currency, amount);
                        resources.put(source, -number);
                        GameOfWhales.this.converting(resources, place);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Consume(String currency, long number, String sink, long amount, String place) {
        if (GameOfWhales.instanceCheck("Consume")) {
            INSTANCE.consume(currency, number, sink, amount, place);
        }
    }

    public void consume(final String currency, final long number, final String sink, final long amount, final String place) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap<String, Long> resources = new HashMap<String, Long>();
                        resources.put(currency, -number);
                        resources.put(sink, amount);
                        GameOfWhales.this.converting(resources, place);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void SetExternalID(String provider, String value) {
        if (GameOfWhales.instanceCheck("SetExternalID")) {
            INSTANCE.setExternalID(provider, value);
        }
    }

    public void setExternalID(final String provider, final String value) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExternalIDCommand cmd = new ExternalIDCommand(provider, value);
                        GameOfWhales.this.queue.add(cmd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void extAdAction(final double revenue, final String platform, final String type, final String unitType) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtAdActionCommand command = new ExtAdActionCommand(platform, revenue, type, unitType);
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void InstallReferrer(Context context, String utm_source, String utm_campaign, String utm_medium, String utm_content, String utm_term, Map<String, Object> extra) {
        try {
            DataStorage storage = null;
            storage = INSTANCE != null ? GameOfWhales.INSTANCE.data : new DataStorage(context, null, null);
            storage.setInstallReferrer(utm_source, utm_campaign, utm_medium, utm_content, utm_term, extra);
            if (INSTANCE != null) {
                INSTANCE.sendInstallReferrerData(storage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendInstallReferrerData(DataStorage fromData) {
        try {
            if (fromData.IsInstallReferrerDataValid()) {
                InstallReferrerCommand cmd = fromData.CreateInstallReferrerCommand();
                this.queue.add(cmd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Converting(String resourcesJson, String place) {
        if (GameOfWhales.instanceCheck("Converting(String)")) {
            try {
                HashMap<String, Long> resources = new HashMap<String, Long>();
                JSONObject object = new JSONObject(resourcesJson);
                Iterator keysItr = object.keys();
                while (keysItr.hasNext()) {
                    String key = (String)keysItr.next();
                    Long value = object.getLong(key);
                    resources.put(key, value);
                }
                INSTANCE.converting(resources, place);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Converting(Map<String, Long> resources, String place) {
        if (GameOfWhales.instanceCheck("Converting(MAP)")) {
            INSTANCE.converting(resources, place);
        }
    }

    public void converting(final Map<String, Long> resources, final String place) {
        try {
            if (this.check("converting")) {
                return;
            }
            if (resources == null) {
                return;
            }
            if (resources.size() == 0) {
                return;
            }
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SpecialOffer offer;
                        ConvertingCommand command = new ConvertingCommand(resources, place);
                        ArrayList debits = new ArrayList();
                        for (Map.Entry entry : resources.entrySet()) {
                            if ((Long)entry.getValue() <= 0L) continue;
                            debits.add(entry.getKey());
                        }
                        if (debits.size() == 1 && (offer = GameOfWhales.this.getSpecialOffer((String)debits.get(0))) != null) {
                            command.setCampaign(offer.campaign);
                            GameOfWhales.this.saveUsedSpecialOffer(offer);
                            GameOfWhales.this.updateSpecialOffers();
                        }
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Profile(String paramsJson) {
        if (GameOfWhales.instanceCheck("Profile String")) {
            INSTANCE.profile(paramsJson);
        }
    }

    public static void Profile(Map<String, Object> params) {
        if (GameOfWhales.instanceCheck("Profile Map")) {
            INSTANCE.profile(params);
        }
    }

    public void readIntent() {
        try {
            L.i(TAG, "Read Intent : ");
            Intent intent = this.activity.getIntent();
            if (intent == null || intent.equals(this.lastIntent)) {
                L.i(TAG, "Same intent : ");
                return;
            }
            this.lastIntent = this.activity.getIntent();
            Bundle extras = this.activity.getIntent().getExtras();
            if (extras != null && extras.containsKey(CAMPAIGN_ID)) {
                String campID = extras.getString(CAMPAIGN_ID);
                L.i(TAG, "Campaign ID : " + campID);
                this.pushReacted(campID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResumed() {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        L.i(GameOfWhales.TAG, "onActivityResumed :");
                        GameOfWhales.this.readIntent();
                        GameOfWhales.this.queue.tryToSendNext(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void profile(final String paramsJSON) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProfileCommand command = new ProfileCommand(paramsJSON);
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void profile(final Map<String, Object> changes) {
        if (this.check("profile")) {
            return;
        }
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProfileCommand command = new ProfileCommand(changes);
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void LoadAd() {
        if (GameOfWhales.instanceCheck("LoadAd")) {
            INSTANCE.loadAd();
        }
    }

    public void loadAd() {
        if (this.check("loadAd")) {
            return;
        }
        if (FetchBitmapAsync.instanceCount > 0) {
            Log.w((String)TAG, (String)"loadAd: some ad already loading");
            return;
        }
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Adv advToLoad = null;
                        int minLoadCount = 10000;
                        for (Map.Entry entry : GameOfWhales.this.advs.entrySet()) {
                            Adv adv = (Adv)entry.getValue();
                            if (adv == null || adv.IsLoaded()) continue;
                            if (adv.GetLoadCount() == 0) {
                                advToLoad = adv;
                                break;
                            }
                            if (adv.GetLoadCount() >= minLoadCount) continue;
                            advToLoad = adv;
                            minLoadCount = adv.GetLoadCount();
                        }
                        if (advToLoad == null) {
                            GameOfWhales.this.onAdvLoadEnded(GameOfWhales.IsAdLoaded());
                            return;
                        }
                        if (advToLoad != null) {
                            advToLoad.IncLoadCount();
                            final Adv adv = advToLoad;
                            ArrayList<String> urls = new ArrayList<String>();
                            urls.add(adv.GetPortraitImage());
                            urls.add(adv.GetLandscapeImage());
                            if (!urls.isEmpty()) {
                                FetchBitmapAsync bitmapTask = new FetchBitmapAsync(urls, new FetchBitmapAsyncListener(){

                                    @Override
                                    public void OnFinished(List<BitmapData> bitmaps) {
                                        try {
                                            BitmapData data;
                                            if (bitmaps.size() >= 1) {
                                                data = bitmaps.get(0);
                                                if (data.bitmap != null && data.url != null && !data.url.isEmpty()) {
                                                    CacheManager.AddBitmap(data.bitmap, data.url);
                                                    adv.SetPortraitLoaded();
                                                } else {
                                                    Log.e((String)GameOfWhales.TAG, (String)"Fetch done 1: bitmap is null");
                                                }
                                            }
                                            if (bitmaps.size() >= 2) {
                                                data = bitmaps.get(1);
                                                if (data.bitmap != null && data.url != null && !data.url.isEmpty()) {
                                                    CacheManager.AddBitmap(data.bitmap, data.url);
                                                    adv.SetLandscapeLoaded();
                                                } else {
                                                    Log.e((String)GameOfWhales.TAG, (String)"Fetch done 2: bitmap is null");
                                                }
                                            }
                                        }
                                        finally {
                                            GameOfWhales.this.AdEvent(adv.GetCamp(), "loaded");
                                            GameOfWhales.this.onAdvLoadEnded(adv.IsLoaded());
                                        }
                                    }
                                });
                                if (Build.VERSION.SDK_INT >= 11) {
                                    bitmapTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                                } else {
                                    bitmapTask.execute(new Void[0]);
                                }
                            } else {
                                Log.e((String)GameOfWhales.TAG, (String)("LoadAd: Urls is empty for " + advToLoad.getId()));
                                GameOfWhales.this.onAdvLoadEnded(adv.IsLoaded());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean IsAdLoaded() {
        if (GameOfWhales.instanceCheck("IsAdLoaded")) {
            return INSTANCE.isAdsLoaded();
        }
        return false;
    }

    public boolean isAdsLoaded() {
        try {
            for (Map.Entry<String, Adv> entry : this.advs.entrySet()) {
                Adv adv = entry.getValue();
                if (!adv.IsLoaded() || !adv.CanShow()) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void ShowAd() {
        if (GameOfWhales.instanceCheck("ShowAd")) {
            INSTANCE.showAds();
        }
    }

    public void showAds() {
        try {
            Object[] values = this.advs.values().toArray();
            if (values.length == 0) {
                Log.e((String)TAG, (String)"NO ADS");
                return;
            }
            Adv adToShow = null;
            int minShowCount = 10000;
            for (Object obj : values) {
                Adv adv = (Adv)obj;
                if (!adv.IsLoaded() || !adv.CanShow() || minShowCount <= adv.GetShowCount()) continue;
                minShowCount = adv.GetShowCount();
                adToShow = adv;
            }
            if (adToShow != null) {
                adToShow.SetShowed();
                this.AdEvent(adToShow.GetCamp(), "showed");
                this.ShowAdsActivity(adToShow);
                return;
            }
            Log.e((String)TAG, (String)"ShowAd: nothing to show");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ShowAdsActivity(final Adv adv) {
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Intent intent = null;
                        intent = GameOfWhales.this.baseOrientation == 1 ? new Intent((Context)GameOfWhales.this.activity, PortraitPromoActivity.class) : new Intent((Context)GameOfWhales.this.activity, LandscapePromoActivity.class);
                        intent.putExtra("title", adv.GetTitle());
                        intent.putExtra("message", adv.GetMessage());
                        intent.putExtra("url", adv.GetUrl());
                        intent.putExtra(GameOfWhales.CAMPAIGN_ID, adv.GetCamp());
                        intent.putExtra("portrait_image", adv.GetPortraitImage());
                        intent.putExtra("landscape_image", adv.GetLandscapeImage());
                        Log.e((String)GameOfWhales.TAG, (String)adv.GetPortraitImage());
                        Log.e((String)GameOfWhales.TAG, (String)adv.GetLandscapeImage());
                        GameOfWhales.this.activity.startActivity(intent);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void InAppPurchased(String dataString, String signature) {
        if (GameOfWhales.instanceCheck("InAppPurchased(String data)")) {
            INSTANCE.inAppPurchased(dataString, signature);
        }
    }

    public void inAppPurchased(String data, String signature) {
        try {
            data = data.substring(data.indexOf("{"));
            JSONObject json = new JSONObject(data);
            String sku = json.getString("productId");
            String orderId = json.getString("orderId");
            Product product = this.getProduct(sku);
            try {
                double price = 0.0;
                String currency = "";
                if (product != null && product.hasDetails()) {
                    price = product.getDoublePrice() * 100.0;
                    currency = product.getPriceCurrencyCode();
                } else {
                    Log.e((String)TAG, (String)("Product has n price! Call 'detailsReceived' method before' : Data:" + data.toString()));
                }
                String payload = GameOfWhales.BuildGooglePayload(data, signature);
                this.purchase(sku, currency, price, orderId, payload.toString(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void InAppPurchased(Intent data) {
        if (GameOfWhales.instanceCheck("InAppPurchased(Intent data)")) {
            INSTANCE.inAppPurchased(data);
        }
    }

    public void inAppPurchased(final Intent data) {
        if (this.check("inAppPurchased")) {
            return;
        }
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int responseCode = data.getIntExtra("RESPONSE_CODE", 0);
                        if (responseCode != 0) {
                            return;
                        }
                        String purchaseData = data.getStringExtra("INAPP_PURCHASE_DATA");
                        String dataSignature = data.getStringExtra("INAPP_DATA_SIGNATURE");
                        JSONObject jo = new JSONObject(purchaseData);
                        String sku = jo.getString("productId");
                        Product product = GameOfWhales.this.getProduct(sku);
                        try {
                            JSONObject payload = new JSONObject();
                            payload.put("json", (Object)purchaseData);
                            payload.put("signature", (Object)dataSignature);
                            JSONObject receipt = new JSONObject(purchaseData);
                            String transactionId = receipt.getString("purchaseToken");
                            receipt.put("Store", (Object)GameOfWhales.STORE_GOOGLEPLAY);
                            receipt.put("TransactionID", (Object)transactionId);
                            receipt.put("Payload", (Object)payload.toString());
                            double price = 0.0;
                            String currency = "";
                            if (product != null && product.hasDetails()) {
                                price = product.getDoublePrice() * 100.0;
                                currency = product.getPriceCurrencyCode();
                            } else {
                                Log.e((String)GameOfWhales.TAG, (String)("Product has n price! Call 'detailsReceived' method before' : Data:" + data.toString()));
                            }
                            GameOfWhales.this.purchase(sku, currency, price, transactionId, payload.toString(), true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateToken(final String token, final String provider) {
        try {
            if (token == null || token.isEmpty()) {
                return;
            }
            if (provider == null || provider.isEmpty()) {
                return;
            }
            if (this.check("updateToken")) {
                return;
            }
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!token.isEmpty()) {
                            GameOfWhales.this.data.setToken(token);
                            GameOfWhales.this.data.setProvider(provider);
                        }
                        TokenCommand command = new TokenCommand(token, provider);
                        GameOfWhales.this.queue.add(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SpecialOffer GetSpecialOffer(String productID) {
        if (GameOfWhales.instanceCheck("GetSpecialOffer")) {
            return INSTANCE.getSpecialOffer(productID);
        }
        return null;
    }

    public boolean hasSpecialOffers() {
        try {
            if (this.check("hasSpecialOffers")) {
                return false;
            }
            return this.activeOffers.size() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Iterable<SpecialOffer> getSpecialOffers() {
        try {
            if (this.check("getSpecialOffers")) {
                return null;
            }
            return this.activeOffers.values();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SpecialOffer getSpecialOffer(String productID) {
        return this.getActiveOfferFor(productID);
    }

    public static SpecialOffer GetFutureSpecialOffer(String productID) {
        if (GameOfWhales.instanceCheck("GetFutureSpecialOffer")) {
            return INSTANCE.getFutureOfferFor(productID);
        }
        return null;
    }

    private void onInitialized() {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onInitialized");
            return;
        }
        L.i(TAG, "onInitialized");
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onInitialized();
        }
    }

    private boolean CanStartExperiment(Experiment experiment) {
        boolean can = false;
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            if (can) {
                listener.CanStartExperiment(experiment);
                continue;
            }
            can = listener.CanStartExperiment(experiment);
        }
        return can;
    }

    private void onExperimentEnded(Experiment experiment) {
        for (GameOfWhalesListener listener : this.listeners) {
            listener.OnExperimentEnded(experiment);
        }
    }

    private void onFutureAppeared(SpecialOffer specialOffer) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onFutureAppeared");
            return;
        }
        if (specialOffer == null) {
            L.e(TAG, "onFutureAppeared: so is null");
            return;
        }
        L.i(TAG, "onFutureAppeared: " + specialOffer.product);
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onFutureSpecialOfferAppeared(specialOffer);
        }
    }

    private void onAppeared(SpecialOffer specialOffer) {
        try {
            if (this.listeners == null) {
                L.e(TAG, "Listeners is null from: onAppeared");
                return;
            }
            if (specialOffer == null) {
                L.e(TAG, "onAppeared: so is null");
                return;
            }
            for (GameOfWhalesListener listener : this.listeners) {
                if (listener == null) continue;
                listener.onSpecialOfferAppeared(specialOffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onDisappeared(SpecialOffer specialOffer) {
        try {
            if (this.listeners == null) {
                L.e(TAG, "Listeners is null from: onPurchaseVerified");
                return;
            }
            if (specialOffer == null) {
                L.e(TAG, "onDisappeared: so is null");
                return;
            }
            for (GameOfWhalesListener listener : this.listeners) {
                if (listener == null) continue;
                listener.onSpecialOfferDisappeared(specialOffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onPurchaseVerified(String transactionID, String state) {
        try {
            if (this.listeners == null) {
                L.w(TAG, "Listeners is null from: onPurchaseVerified");
                return;
            }
            for (GameOfWhalesListener listener : this.listeners) {
                if (listener == null) continue;
                listener.onPurchaseVerified(transactionID, state);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onAdvLoadEnded(boolean loaded) {
        try {
            if (this.listeners == null) {
                L.w(TAG, "Listeners is null from: onPurchaseVerified");
                return;
            }
            for (GameOfWhalesListener listener : this.listeners) {
                if (listener == null) continue;
                if (loaded) {
                    listener.onAdLoaded();
                    continue;
                }
                listener.onAdLoadFailed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyAdClosed() {
        if (this.listeners == null) {
            L.w(TAG, "Listeners is null from: notifyAdClosed");
            return;
        }
        try {
            for (GameOfWhalesListener listener : this.listeners) {
                listener.onAdClosed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyPushDelivered(boolean isOffer, String campID, String title, String message) {
        if (this.listeners == null) {
            L.w(TAG, "Listeners is null from: notifyPushDelivered");
            return;
        }
        try {
            SpecialOffer so = null;
            if (isOffer && (so = this.getSpecialOfferByCamp(campID)) == null) {
                DelayedNofification dn = new DelayedNofification();
                dn.camp = campID;
                dn.title = title;
                dn.messasge = message;
                this.delayedNofifications.add(dn);
                this.queue.tryToSendNext(true);
                return;
            }
            this.notifyPushDeliveredWithOffer(so, campID, title, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkDelayedNotifications() {
        try {
            HashMap<String, DelayedNofification> notifications = new HashMap<String, DelayedNofification>();
            for (Map.Entry<String, SpecialOffer> entry : this.activeOffers.entrySet()) {
                SpecialOffer so = entry.getValue();
                for (DelayedNofification dn : this.delayedNofifications) {
                    if (!so.campaign.equals(dn.camp)) continue;
                    dn.offer = so;
                    notifications.put(so.campaign, dn);
                }
            }
            for (Map.Entry<String, SpecialOffer> entry : notifications.entrySet()) {
                DelayedNofification dn = (DelayedNofification)((Object)entry.getValue());
                this.delayedNofifications.remove(dn);
                this.notifyPushDeliveredWithOffer(dn.offer, dn.camp, dn.title, dn.messasge);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void notifyPushDeliveredWithOffer(SpecialOffer offer, String campID, String title, String message) {
        try {
            for (GameOfWhalesListener listener : this.listeners) {
                if (listener == null) continue;
                listener.onPushDelivered(offer, campID, title, message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onCommandResponse(Command command, JSONObject response) {
        if (response == null) {
            return;
        }
        L.i(TAG, "onCommandResponse: " + response.toString());
        try {
            this.readServerTime(response);
            this.readSegments(response);
            this.readSpecialOffers(response);
            this.readExperiment(response);
            this.readVerifyState(response);
            this.readAds(response);
            this.readProperties(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveUsedSpecialOffer(SpecialOffer offer) {
        try {
            if (this.check("saveUsedSpecialOffer")) {
                return;
            }
            for (SpecialOfferData ofdata : this.specialOfferData) {
                if (!ofdata.getId().equals(offer.campaign) || !ofdata.isRedeemable()) continue;
                ofdata.setUsed(true);
                this.data.addSpecialOffer(ofdata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isSpecialOfferUsed(String campaingID) {
        if (this.check("isSpecialOfferUsed")) {
            return false;
        }
        try {
            SpecialOfferData ofdata = this.data.getSpecialOffer(campaingID);
            if (ofdata != null) {
                return ofdata.isUsed();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void runUpdate() {
        try {
            if (this.batchingHandler == null) {
                L.e(TAG, "batchingHandler is null, from run update");
                return;
            }
            this.batchingHandler.postDelayed(this.updateRunner, 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean check(String from) {
        if (this.queue == null) {
            L.e(TAG, "Queue is null from: " + from);
            return true;
        }
        if (this.activeOffers == null) {
            L.e(TAG, "Active Offers is null from: " + from);
            return true;
        }
        if (this.data == null) {
            L.e(TAG, "Data is null from: " + from);
            return true;
        }
        if (this.specialOfferData == null) {
            L.e(TAG, "specialOfferData is null from: " + from);
            return true;
        }
        if (this.products == null) {
            L.e(TAG, "products is null from: " + from);
            return true;
        }
        return false;
    }

    public static void SubscribeErrors() {
        L.d(TAG, "ErrorsSubscribe");
        try {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread paramThread, Throwable paramThrowable) {
                    try {
                        if (GameOfWhales.instanceCheck("uncaughtException")) {
                            L.d(GameOfWhales.TAG, "uncaughtException");
                            StackTraceElement[] elements = paramThrowable.getStackTrace();
                            String stacktrace = "";
                            for (StackTraceElement el : elements) {
                                stacktrace = stacktrace + el.toString() + "\n";
                            }
                            ErrorCommand command = new ErrorCommand(paramThrowable.getMessage(), stacktrace);
                            INSTANCE.data.addCommand(command);
                            Intent intent = new Intent((Context)INSTANCE.activity, INSTANCE.activity.getClass());
                            INSTANCE.activity.startActivity(intent);
                            Process.killProcess((int)Process.myPid());
                            System.exit(0);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String BuildGooglePayload(String origJson, String signature) {
        try {
            JSONObject object = new JSONObject();
            JSONObject payload = new JSONObject();
            payload.put("json", (Object)origJson);
            payload.put("signature", (Object)signature);
            return payload.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String BuildGooglePlayReceipt(String origJson, String signature) {
        try {
            JSONObject object = new JSONObject();
            try {
                JSONObject payload = new JSONObject();
                payload.put("json", (Object)origJson);
                payload.put("signature", (Object)signature);
                JSONObject receipt = new JSONObject(origJson);
                String transactionId = receipt.getString("purchaseToken");
                receipt.put("Store", (Object)STORE_GOOGLEPLAY);
                receipt.put("TransactionID", (Object)transactionId);
                receipt.put("Payload", (Object)payload.toString());
                return receipt.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
                return object.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String BuildSamsungReceipt(String paymentID, String purchaseID) {
        try {
            JSONObject object = new JSONObject();
            JSONObject payload = new JSONObject();
            try {
                object.put("Store", (Object)STORE_SAMSUNG);
                object.put("TransactionID", (Object)paymentID);
                payload.put("purchaseId", (Object)purchaseID);
                object.put("Payload", (Object)payload.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return object.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        VERSION_SDK = VERSION = "2.0.29";
    }
}

