/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.R;
import com.gameofwhales.sdk.util.CacheManager;

public class BasePromoActivity
extends Activity {
    private static final String TAG = "GOW.PromoActivity";
    String title;
    String message;
    String url;
    String camp;
    String portrait_image;
    String landscape_image;
    Bitmap bitmap;
    TextView titleText;
    TextView messageText;
    Button buttonInstall;
    Button closeButton;
    ImageView image;
    boolean portrait = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
            Intent intent = this.getIntent();
            this.camp = intent.getStringExtra("camp");
            this.title = intent.getStringExtra("title");
            this.message = intent.getStringExtra("message");
            this.url = intent.getStringExtra("url");
            this.portrait_image = intent.getStringExtra("portrait_image");
            this.landscape_image = intent.getStringExtra("landscape_image");
            this.setContentView(R.layout.gow_activity_promo_portrait);
            this.image = (ImageView)this.findViewById(R.id.gow_interstitial_image);
            this.closeButton = (Button)this.findViewById(R.id.gow_close_button);
            this.UpdateOrientation();
            if (this.closeButton != null) {
                this.closeButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        BasePromoActivity.this.CloseActivity();
                    }
                });
            }
            if (this.image != null) {
                this.image.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (GameOfWhales.getInstance() != null) {
                            GameOfWhales.getInstance().AdEvent(BasePromoActivity.this.camp, "clicked");
                        }
                        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)BasePromoActivity.this.url));
                        BasePromoActivity.this.CloseActivity();
                        BasePromoActivity.this.startActivity(browserIntent);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish();
        }
    }

    public void onBackPressed() {
        this.CloseActivity();
    }

    private void CloseActivity() {
        try {
            if (GameOfWhales.getInstance() != null) {
                GameOfWhales.getInstance().notifyAdClosed();
            }
            this.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void UpdateOrientation() {
        try {
            int orientation = GameOfWhales.getInstance().getBaseOrientation();
            Bitmap bitmap = null;
            if (orientation == 2) {
                this.setRequestedOrientation(0);
                bitmap = CacheManager.GetBitmap(this.landscape_image);
                if (bitmap == null) {
                    Log.e((String)TAG, (String)"Landscape bitmap is null");
                    bitmap = CacheManager.GetBitmap(this.portrait_image);
                }
            } else if (orientation == 1) {
                this.setRequestedOrientation(1);
                bitmap = CacheManager.GetBitmap(this.portrait_image);
                if (bitmap == null) {
                    Log.e((String)TAG, (String)"Portrait bitmap is null");
                    bitmap = CacheManager.GetBitmap(this.landscape_image);
                }
            }
            if (bitmap != null) {
                if (this.image != null) {
                    this.image.setImageBitmap(bitmap);
                }
            } else {
                Log.e((String)TAG, (String)"CheckOrientation: bitmap is null");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"resizing");
            CacheManager.Resize(this.landscape_image);
            CacheManager.Resize(this.portrait_image);
            return;
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }
}

