/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.async.NotificationTask;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.PushDeliveredCommand;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.GOWBroadcastReceiver;
import com.gameofwhales.sdk.util.InternalResponseListener;
import com.gameofwhales.sdk.util.RequestBuilder;
import com.gameofwhales.sdk.util.Utils;
import com.gameofwhales.sdk.util.net.HTTP;
import org.json.JSONObject;

public class GOWPushService
extends IntentService {
    private static String TAG = "GOW.PushService";
    private Intent intent;
    private DataStorage data = null;
    private HTTP http = null;
    InternalResponseListener listener = new InternalResponseListener(null){

        @Override
        public void OnResponse(Command command, boolean error, JSONObject response) {
            try {
                L.i(TAG, "onResponse: error: " + error + ", response: " + response);
                if (error) {
                    GOWPushService.this.finishSend();
                    GOWPushService.this.complete();
                    return;
                }
                GOWPushService.this.sendPack();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public GOWPushService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        try {
            boolean isOffer;
            L.i(TAG, "onHandleIntent");
            this.intent = intent;
            Bundle extras = intent.getExtras();
            String campID = extras.getString("camp");
            String title = extras.getString("title");
            String message = extras.getString("subtitle");
            String campType = extras.getString("campType");
            boolean bl = isOffer = campType != null && campType.equals("specialOffers");
            if (GameOfWhales.getInstance() != null) {
                if (GameOfWhales.getInstance().IsPushWasShown(campID)) {
                    L.w(TAG, "Push (" + campID + ") already shown. Ignoring..");
                    this.complete();
                    return;
                }
                GameOfWhales.getInstance().SetPushShown(campID);
            } else {
                this.data = new DataStorage((Context)this, null, null);
                if (this.data.IsPushShown(campID)) {
                    L.w(TAG, "Push (" + campID + ") already shown. Ignoring.");
                    this.complete();
                    return;
                }
                this.data.SetPushShown(campID);
            }
            L.i(TAG, "IsForeground: " + GameOfWhales.IsAppForeground());
            if (GameOfWhales.IsAppForeground()) {
                if (GameOfWhales.getInstance() != null) {
                    GameOfWhales.getInstance().notifyPushDelivered(isOffer, campID, title, message);
                }
            } else {
                NotificationTask notification = new NotificationTask((Context)this, extras, null);
                notification.show();
                this.complete();
            }
            if (GameOfWhales.getInstance() != null) {
                GameOfWhales.PushDelivered(campID);
            } else if (!this.data.IsCampExists(campID, "push_delivered")) {
                this.data.AddCamp(campID, "push_delivered");
                this.data.addCommand(new PushDeliveredCommand(campID));
                this.sendPack();
            } else {
                L.w(TAG, "Push was already delivered: '" + campID + "'");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void finishSend() {
        try {
            this.data = null;
            this.http = null;
            this.complete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendPack() {
        try {
            if (!Utils.IsOnline((Context)this)) {
                Log.i((String)TAG, (String)"No internet. Will send later");
                this.finishSend();
                return;
            }
            if (this.data == null) {
                this.data = new DataStorage((Context)this, null, null);
                if (!this.data.isReady()) {
                    Log.i((String)TAG, (String)"data is not ready");
                    this.finishSend();
                    return;
                }
            }
            if (this.data.getCommands().size() == 0) {
                this.finishSend();
                return;
            }
            if (this.http == null) {
                this.http = new HTTP();
            }
            try {
                RequestBuilder.createPackAndSend(this.http, this.data, 10, false, false, this.listener);
            }
            catch (Exception e) {
                L.e(TAG, "Request create json error!");
                e.printStackTrace();
                this.finishSend();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void complete() {
        try {
            if (this.http == null) {
                GOWBroadcastReceiver.completeWakefulIntent((Intent)this.intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

