/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol.commands;

import com.gameofwhales.sdk.protocol.commands.Command;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseCommand
extends Command {
    public static String ID = "purchase";
    private String product;
    private String currency;
    private String store;
    private double price;
    private String transactionId;
    private String receipt;
    private boolean verify;
    private String camp;

    public PurchaseCommand(String product, String currency, String store, double price) {
        this.id = ID;
        this.product = product;
        this.currency = currency;
        this.store = store;
        this.price = price;
        this.verify = false;
    }

    public PurchaseCommand(JSONObject object) {
        this.load(object);
    }

    public void SetTransactionID(String transactionId) {
        this.transactionId = transactionId;
    }

    public void SetVerify(boolean value) {
        this.verify = value;
    }

    public void SetReceipt(String receipt) {
        this.receipt = receipt;
    }

    public void setCampaign(String camp) {
        this.camp = camp;
    }

    @Override
    public JSONObject getArgs() {
        try {
            JSONObject args = new JSONObject();
            args.put("event", (Object)this.getID());
            args.put("at", this.getAt());
            args.put("currency", (Object)this.currency);
            args.put("price", this.price);
            args.put("store", (Object)this.store);
            args.put("product", (Object)this.product);
            args.put("verify", this.verify);
            if (this.transactionId != null && this.transactionId.length() > 0) {
                args.put("transactionId", (Object)this.transactionId);
            }
            if (this.receipt != null && this.receipt.length() > 0) {
                args.put("receipt", (Object)this.receipt);
            }
            if (this.camp != null && !this.camp.isEmpty()) {
                args.put("camp", (Object)this.camp);
            }
            return args;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void load(JSONObject object) {
        try {
            this.id = object.getString("event");
            this.at = object.getLong("at");
            this.currency = object.getString("currency");
            this.price = object.getDouble("price");
            this.receipt = object.getString("receipt");
            this.transactionId = object.getString("transactionId");
            this.product = object.getString("product");
            this.store = object.getString("store");
            this.verify = object.getBoolean("verify");
            if (object.has("transactionId")) {
                this.transactionId = object.getString("transactionId");
            }
            if (object.has("receipt")) {
                this.receipt = object.getString("receipt");
            }
            if (object.has("camp")) {
                this.camp = object.getString("camp");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject save() {
        return this.getArgs();
    }
}

