/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.async;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Log;
import com.gameofwhales.sdk.async.FetchBitmapAsyncListener;
import com.gameofwhales.sdk.util.BitmapData;
import com.gameofwhales.sdk.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class FetchBitmapAsync
extends AsyncTask<Void, Void, List<BitmapData>> {
    public static int instanceCount = 0;
    private static final String TAG = "GOQ.FetchBitmapAsync";
    private FetchBitmapAsyncListener listener;
    private List<String> urls;
    private List<BitmapData> result = new ArrayList<BitmapData>();

    public FetchBitmapAsync(List<String> urls, FetchBitmapAsyncListener listener) {
        try {
            this.listener = listener;
            this.urls = urls;
            ++instanceCount;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected List<BitmapData> doInBackground(Void ... params) {
        try {
            for (String url : this.urls) {
                Bitmap bitmap = null;
                if (url != null && !url.isEmpty()) {
                    bitmap = Utils.FetchBitmap(url);
                } else {
                    Log.e((String)TAG, (String)"Url is empty or null");
                }
                BitmapData data = new BitmapData();
                data.url = url;
                data.bitmap = bitmap;
                this.result.add(data);
            }
            return this.result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onPostExecute(List<BitmapData> bitmaps) {
        try {
            --instanceCount;
            if (this.listener != null) {
                this.listener.OnFinished(bitmaps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

