/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk;

import android.app.Activity;
import android.content.Context;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.util.CommandListener;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.InternalResponseListener;
import com.gameofwhales.sdk.util.RequestBuilder;
import com.gameofwhales.sdk.util.Utils;
import com.gameofwhales.sdk.util.net.HTTP;
import org.json.JSONObject;

public class CommandQueue {
    private static String TAG = "CommandQueue";
    public static final int BATCH_COUNT = 10;
    CommandListener listener;
    private final HTTP http;
    private final Activity activity;
    private final DataStorage data;

    CommandQueue(Activity activity, DataStorage data, CommandListener listener) {
        this.activity = activity;
        this.listener = listener;
        this.data = data;
        this.http = new HTTP();
    }

    public int getCommandCount() {
        try {
            if (this.check("getCommandCount")) {
                return 0;
            }
            return this.data.getCommands().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private boolean check(String from) {
        if (this.data == null) {
            L.e(TAG, "Data is null from: " + from);
            return true;
        }
        return false;
    }

    public void add(Command command) {
        try {
            if (this.check("Add command")) {
                return;
            }
            if (command == null) {
                L.e(TAG, "Command is null");
                return;
            }
            this.data.addCommand(command);
            if (this.getCommandCount() >= 10) {
                this.tryToSendNext(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tryToSendNext(boolean canSendEmpty) {
        try {
            if (this.check("tryToSendNext")) {
                return;
            }
            if (this.data.isReady()) {
                this.sendPack(canSendEmpty);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printQueue() {
        try {
            if (this.check("printQueue")) {
                return;
            }
            L.i(TAG, "Command queue");
            for (Command command : this.data.getCommands()) {
                L.i(TAG, "    " + command.getID());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void sendPack(final boolean canSendEmpty) {
        try {
            if (this.check("sendPack")) {
                return;
            }
            if (this.data.getCommands().size() == 0 && !canSendEmpty) {
                L.i(TAG, "sendPack: no commands");
                return;
            }
            if (!this.data.isReady()) {
                L.i(TAG, "sendPack: SDK not ready yet!");
                return;
            }
            if (!Utils.IsOnline((Context)this.activity)) {
                L.i(TAG, "sendPack: No internet, will send later");
                return;
            }
            final InternalResponseListener listener = new InternalResponseListener(){

                @Override
                public void OnResponse(Command command, boolean error, JSONObject response) {
                    L.i(TAG, "OnCommandPackResponse:  error: " + String.valueOf(error) + " response: " + response);
                    if (!error) {
                        if (CommandQueue.this == null) {
                            return;
                        }
                        if (CommandQueue.this.listener != null) {
                            CommandQueue.this.listener.onCommandResponse(command, response);
                        }
                        CommandQueue.this.tryToSendNext(false);
                    }
                }
            };
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RequestBuilder.createPackAndSend(CommandQueue.this.http, CommandQueue.this.data, 10, canSendEmpty, true, listener);
                    }
                    catch (Exception e) {
                        L.e(TAG, "sendPack in UI: createPackAndSend error!");
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            L.e(TAG, "sendPack: Request create json error!");
            e.printStackTrace();
        }
    }
}

