/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Set;

public class GOWInstallReferrer
extends BroadcastReceiver {
    private final String TAG = "GOWInstallReferrer";
    private static final String[] EXPECTED_PARAMETERS = new String[]{"utm_source", "utm_medium", "utm_term", "utm_content", "utm_campaign"};

    public void onReceive(Context context, Intent intent) {
        Log.i((String)"GOWInstallReferrer", (String)("GOWInstallReferrer: " + intent.toString()));
        try {
            Bundle extras = intent.getExtras();
            if (extras != null) {
                extras.containsKey(null);
            }
        }
        catch (Exception e) {
            Log.e((String)"GOWInstallReferrer", (String)"Bundle exeption");
            return;
        }
        try {
            if (!intent.getAction().equals("com.android.vending.INSTALL_REFERRER")) {
                Log.i((String)"GOWInstallReferrer", (String)"Wrong intent action");
                return;
            }
            String referrer = intent.getStringExtra("referrer");
            if (referrer == null || referrer.length() == 0) {
                Log.i((String)"GOWInstallReferrer", (String)"Empty referrer");
                return;
            }
            Log.i((String)"GOWInstallReferrer", (String)("Referrer: " + referrer));
            Uri uri = Uri.parse((String)("https://gameofwhales.com/?" + referrer));
            Log.i((String)"GOWInstallReferrer", (String)("URI: " + uri.getQueryParameter("utm_source")));
            Log.i((String)"GOWInstallReferrer", (String)("URI: " + uri.getQueryParameter("utm_medium")));
            Log.i((String)"GOWInstallReferrer", (String)("URI: " + uri.getQueryParameter("utm_term")));
            Log.i((String)"GOWInstallReferrer", (String)("URI: " + uri.getQueryParameter("utm_content")));
            Log.i((String)"GOWInstallReferrer", (String)("URI: " + uri.getQueryParameter("utm_campaign")));
            String utm_source = uri.getQueryParameter("utm_source");
            String utm_campaign = uri.getQueryParameter("utm_campaign");
            String utm_medium = uri.getQueryParameter("utm_medium");
            String utm_content = uri.getQueryParameter("utm_content");
            String utm_term = uri.getQueryParameter("utm_term");
            HashMap<String, Object> extra = new HashMap<String, Object>();
            Set parameters = uri.getQueryParameterNames();
            for (String name : parameters) {
                boolean isExpected = false;
                for (String exptected : EXPECTED_PARAMETERS) {
                    if (!name.equals(exptected)) continue;
                    isExpected = true;
                    break;
                }
                if (isExpected) continue;
                extra.put(name, uri.getQueryParameter(name));
            }
            ComponentName componentName = new ComponentName(context, GOWInstallReferrer.class);
            ActivityInfo info = context.getPackageManager().getReceiverInfo(componentName, 128);
            for (String key : info.metaData.keySet()) {
                try {
                    String className = info.metaData.getString(key);
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    BroadcastReceiver otherReceiver = (BroadcastReceiver)ctor.newInstance(new Object[0]);
                    Log.i((String)"GOWInstallReferrer", (String)("Pass data to next InstallReferrer Receiver: " + className));
                    otherReceiver.onReceive(context, intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            GameOfWhales.InstallReferrer(context, utm_source, utm_campaign, utm_medium, utm_content, utm_term, extra);
        }
        catch (Exception e) {
            Log.e((String)"GOWInstallReferrer", (String)"Install Referrer parse exception");
            e.printStackTrace();
            return;
        }
    }
}

