/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol.commands;

import com.gameofwhales.sdk.protocol.commands.Command;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiptCommand
extends Command {
    public static String ID = "receipt";
    private String currency;
    private double price;
    private String transactionId;
    private String receipt;
    private String camp;

    public ReceiptCommand(String transactionId, String receipt) {
        this.id = ID;
        this.transactionId = transactionId;
        this.receipt = receipt;
    }

    public ReceiptCommand(JSONObject object) {
        this.load(object);
    }

    public ReceiptCommand setPrice(double price) {
        this.price = price * 100.0;
        return this;
    }

    public ReceiptCommand setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public ReceiptCommand setCampaign(String campaignID) {
        this.camp = campaignID;
        return this;
    }

    @Override
    public void load(JSONObject object) {
        try {
            this.id = object.getString("event");
            this.at = object.getLong("at");
            this.currency = object.getString("currency");
            this.price = object.getDouble("price");
            this.receipt = object.getString("receipt");
            this.transactionId = object.getString("transactionId");
            if (object.has("camp")) {
                this.camp = object.getString("camp");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject save() {
        return this.getArgs();
    }

    @Override
    public boolean canSend() {
        return super.canSend() && this.price > (double)1.0E-4f && !this.currency.isEmpty();
    }

    @Override
    public JSONObject getArgs() {
        try {
            JSONObject args = new JSONObject();
            args.put("event", (Object)this.getID());
            args.put("at", this.getAt());
            args.put("currency", (Object)this.currency);
            args.put("price", this.price);
            args.put("receipt", (Object)this.receipt);
            args.put("transactionId", (Object)this.transactionId);
            if (this.camp != null && !this.camp.isEmpty()) {
                args.put("camp", (Object)this.camp);
            }
            return args;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

