/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.async;

import android.content.Context;
import android.os.AsyncTask;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.util.GCMHelper;

public class GCMAsyncTask
extends AsyncTask<Void, Void, String> {
    private static String TAG = "GCMAsyncTask";
    private String androidID;
    private Context context;

    public GCMAsyncTask(Context context, String androidID) {
        try {
            L.d(TAG, "GCMAsyncTask");
            this.androidID = androidID;
            this.context = context;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String doInBackground(Void ... params) {
        try {
            L.d(TAG, "doInBackground");
            if (GameOfWhales.getInstance() != null) {
                String token;
                GCMHelper gcm = new GCMHelper(this.androidID);
                if (gcm.isGCMAvailable() && (token = gcm.requestToken(this.context)) != null) {
                    return token;
                }
            } else {
                L.e(TAG, "GOW not initialized");
            }
        }
        catch (Exception e) {
            L.e(TAG, "Failed to handle token intent");
            e.printStackTrace();
        }
        return "";
    }

    protected void onPostExecute(String token) {
        try {
            L.d(TAG, "onPostExecute: " + token);
            if (token != null && !token.isEmpty()) {
                L.i(TAG, "New GCM token: " + token);
                GameOfWhales.getInstance().updateToken(token, "gcm");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

