/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class GowLruCache<K, V> {
    private final LinkedHashMap<K, V> map = new LinkedHashMap(0, 0.75f, true);
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public GowLruCache(int maxSize) {
        try {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize <= 0");
            }
            this.maxSize = maxSize;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final synchronized V get(K key) {
        try {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            V result = this.map.get(key);
            if (result != null) {
                ++this.hitCount;
                return result;
            }
            ++this.missCount;
            result = this.create(key);
            if (result != null) {
                ++this.createCount;
                this.size += this.safeSizeOf(key, result);
                this.map.put(key, result);
                this.trimToSize(this.maxSize);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final synchronized V put(K key, V value) {
        try {
            if (key == null || value == null) {
                throw new NullPointerException("key == null || value == null");
            }
            ++this.putCount;
            this.size += this.safeSizeOf(key, value);
            V previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            this.trimToSize(this.maxSize);
            return previous;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void trimToSize(int maxSize) {
        try {
            Map.Entry<K, V> toEvict;
            while (this.size > maxSize && !this.map.isEmpty() && (toEvict = this.map.entrySet().iterator().next()) != null) {
                K key = toEvict.getKey();
                V value = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.safeSizeOf(key, value);
                ++this.evictionCount;
                this.entryEvicted(key, value);
            }
            if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final synchronized V remove(K key) {
        try {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            Object previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            return previous;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void entryEvicted(K key, V value) {
    }

    protected V create(K key) {
        return null;
    }

    private int safeSizeOf(K key, V value) {
        try {
            int result = this.sizeOf(key, value);
            if (result < 0) {
                throw new IllegalStateException("Negative size: " + key + "=" + value);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final synchronized void evictAll() {
        try {
            this.trimToSize(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        try {
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, hitPercent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

