/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util.net;

import android.os.AsyncTask;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.util.net.HTTPListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;

public class HTTPAsyncTask
extends AsyncTask<Void, Void, Void> {
    private static final String TAG = "HTTPAsyncTask";
    private String url = null;
    private String data = null;
    private int responseCode = -1;
    private String responseData = "";
    private HTTPListener listener;

    public HTTPAsyncTask(String url, JSONObject data, HTTPListener listener) {
        this(url, data.toString(), listener);
    }

    public HTTPAsyncTask(String url, String data, HTTPListener listener) {
        this.url = url;
        this.data = data;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(Void[] params) {
        HttpURLConnection con = null;
        try {
            L.i(TAG, "HTTPAsyncTask sending: " + this.url + "\n" + this.data);
            URL Url = new URL(this.url);
            con = (HttpURLConnection)Url.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setUseCaches(false);
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.setRequestProperty("Content-Type", "application/json");
            con.connect();
            DataOutputStream printout = new DataOutputStream(con.getOutputStream());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)printout, "UTF-8"));
            writer.write(this.data);
            writer.close();
            printout.close();
            this.responseCode = con.getResponseCode();
            if (this.responseCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.responseData = this.responseData + line;
                }
                L.i(TAG, "response[" + this.responseCode + "]: " + this.responseData);
                br.close();
            } else {
                L.i(TAG, "response error: " + this.responseCode);
            }
        }
        catch (MalformedURLException e) {
            L.e(TAG, "Error while request: " + this.url);
            e.printStackTrace();
        }
        catch (IOException e) {
            L.e(TAG, "Error while request: " + this.url);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.disconnect();
        }
        return null;
    }

    protected void onPostExecute(Void obj) {
        if (this.listener != null) {
            this.listener.OnResponse(this, this.responseCode != 200, this.responseData);
        }
    }
}

