/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.protocol.SpecialOfferData;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.CommandFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataStorage {
    public static final String CAMP_TYPE__PUSHREACTED = "push_reacted";
    public static final String CAMP_TYPE__PUSHDELIVERED = "push_delivered";
    public static final String CAMP_TYPE__PROMOADCLICKED = "promoad_clicked";
    private static String TAG = "GOW.DataStorage";
    private static final String DATA_FILE = "gow.data";
    private static final String GAME_KEY = "gameOfWhales.gameId";
    private String gameID = "";
    private String advID = "";
    private String token = "";
    private String store = "";
    private boolean notificationsEnable = true;
    private String provider = "";
    private String platform;
    private String version;
    private List<Command> commands = new ArrayList<Command>();
    private List<SpecialOfferData> offers = new ArrayList<SpecialOfferData>();
    private List<String> deliveredPushes = new ArrayList<String>();
    private List<String> reactedPushes = new ArrayList<String>();
    private Context context;
    private Map<String, Boolean> camps = new HashMap<String, Boolean>();

    public DataStorage(Context context, String gameID, String store) {
        try {
            this.context = context;
            this.loadData();
            if (gameID != null) {
                this.gameID = gameID;
            }
            if (store != null) {
                this.store = store;
            }
            this.readGameIDFromManifest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Command> getCommandsAndRemove(int maxCount) {
        try {
            if (this.commands == null) {
                L.e(TAG, "Commands is null from: addCommand");
                return null;
            }
            ArrayList<Command> list = new ArrayList<Command>();
            int count = 0;
            Iterator<Command> iterator = this.commands.iterator();
            while (iterator.hasNext()) {
                Command cmd = iterator.next();
                if (cmd == null) continue;
                list.add(cmd);
                iterator.remove();
                if (++count < maxCount) continue;
                break;
            }
            this.saveData();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void addCommand(Command command) {
        try {
            if (this.commands == null) {
                L.e(TAG, "Commands is null from: addCommand");
                return;
            }
            this.commands.add(command);
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearCommands() {
        try {
            if (this.commands == null) {
                L.e(TAG, "Commands is null from: clearCommands");
                return;
            }
            this.commands.clear();
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void AddCamp(String camp, String type) {
        try {
            if (camp == null || camp.isEmpty()) {
                Log.e((String)TAG, (String)"AddCamp camp is null");
                return;
            }
            if (type == null || type.isEmpty()) {
                Log.e((String)TAG, (String)"AddCamp type is null");
                return;
            }
            String id2 = camp + "-" + type;
            if (this.IsCampExists(camp, type)) {
                Log.e((String)TAG, (String)("camp already exists: " + id2));
                return;
            }
            this.camps.put(id2, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean IsCampExists(String camp, String type) {
        try {
            String id2 = camp + "-" + type;
            return this.camps.containsKey(id2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getGameID() {
        return this.gameID;
    }

    public String getAdvID() {
        return this.advID;
    }

    public void setProvider(String value) {
        this.provider = this.provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getToken() {
        return this.token;
    }

    public String getStore() {
        return this.store;
    }

    public boolean isNotificationsEnable() {
        return this.notificationsEnable;
    }

    public void setNotificationsEnable(boolean value) {
        try {
            this.notificationsEnable = value;
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setGameID(String gameID) {
        try {
            this.gameID = gameID;
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void SetPlatform(String platform) {
        try {
            this.platform = platform;
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String GetPlatform() {
        return this.platform;
    }

    public void SetVersion(String version) {
        try {
            this.version = version;
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String GetVersion() {
        return this.version;
    }

    public void setAdvID(String advID) {
        try {
            this.advID = advID;
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setToken(String token) {
        try {
            this.token = token;
            this.saveData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isReady() {
        try {
            boolean isReady;
            if (this.advID == null || this.gameID == null) {
                return false;
            }
            boolean bl = isReady = !this.advID.isEmpty() && !this.gameID.isEmpty();
            if (L.isDebug) {
                L.d(TAG, "isSDKReady called");
                L.d(TAG, "    AdverstingID: " + this.advID);
                L.d(TAG, "    gameID:       " + this.gameID);
                L.d(TAG, "    store:       " + this.store);
                L.d(TAG, "    State: " + (isReady ? "Ready" : "Not ready"));
            }
            return isReady;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addSpecialOffer(SpecialOfferData offer) {
        try {
            this.offers.add(offer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SpecialOfferData getSpecialOffer(String id2) {
        try {
            if (this.offers == null) {
                L.e(TAG, "Offers is null from: offers");
                return null;
            }
            for (SpecialOfferData offer : this.offers) {
                if (offer == null || !offer.getId().equals(id2)) continue;
                return offer;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveData() {
        try {
            L.i(TAG, "Saving data...");
            JSONObject json = new JSONObject();
            json.put("gameID", (Object)this.gameID);
            json.put("userID", (Object)this.advID);
            json.put("token", (Object)this.token);
            json.put("store", (Object)this.store);
            json.put("notificationsEnable", this.notificationsEnable);
            json.put("provider", (Object)this.provider);
            json.put("version", (Object)this.version);
            json.put("platform", (Object)this.platform);
            JSONArray commandsArray = new JSONArray();
            int count = 1;
            for (Command command : this.commands) {
                String data = command.save().toString();
                data = null;
                L.i(TAG, "Saving command [" + count + "]: " + data);
                ++count;
                commandsArray.put((Object)command.save());
            }
            json.put("commands", (Object)commandsArray);
            JSONArray campsArray = new JSONArray();
            for (Map.Entry<String, Boolean> entry : this.camps.entrySet()) {
                campsArray.put((Object)entry.getKey());
            }
            json.put("camps", (Object)campsArray);
            L.i(TAG, "Saved data: " + json.toString());
            FileOutputStream fos = this.context.openFileOutput(DATA_FILE, 0);
            fos.write(json.toString().getBytes());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadData() {
        try {
            L.i(TAG, "Reading data...");
            try {
                int i;
                StringBuffer datax = new StringBuffer("");
                FileInputStream fIn = this.context.openFileInput(DATA_FILE);
                InputStreamReader isr = new InputStreamReader(fIn);
                BufferedReader buffreader = new BufferedReader(isr);
                String readString = buffreader.readLine();
                while (readString != null) {
                    datax.append(readString);
                    readString = buffreader.readLine();
                }
                isr.close();
                JSONObject json = new JSONObject(datax.toString());
                L.i(TAG, "Loaded data: " + json.toString());
                if (json.has("gameID")) {
                    this.gameID = json.getString("gameID");
                }
                if (json.has("commands")) {
                    JSONArray commandsArray = json.getJSONArray("commands");
                    for (i = 0; i < commandsArray.length(); ++i) {
                        JSONObject object = commandsArray.getJSONObject(i);
                        L.i(TAG, "read command: " + object.toString());
                        Command command = CommandFactory.create(object);
                        if (command == null) continue;
                        this.commands.add(command);
                    }
                }
                this.camps.clear();
                if (json.has("camps")) {
                    JSONArray campsArray = json.getJSONArray("camps");
                    for (i = 0; i < campsArray.length(); ++i) {
                        String id2 = campsArray.getString(i);
                        L.i(TAG, "read camp id: " + id2);
                        this.camps.put(id2, true);
                    }
                }
                this.platform = json.has("platform") ? json.getString("platform") : GameOfWhales.platform;
                this.version = json.has("version") ? json.getString("version") : GameOfWhales.VERSION;
                if (json.has("userID")) {
                    this.advID = json.getString("userID");
                }
                if (json.has("token")) {
                    this.token = json.getString("token");
                }
                if (json.has("store")) {
                    this.store = json.getString("store");
                }
                if (json.has("notificationsEnable")) {
                    this.notificationsEnable = json.getBoolean("notificationsEnable");
                }
                if (json.has("provider")) {
                    this.provider = json.getString("provider");
                }
            }
            catch (FileNotFoundException datax) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readGameIDFromManifest() {
        block6: {
            try {
                if (this.gameID != null && !this.gameID.isEmpty()) break block6;
                try {
                    ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
                    Bundle bundle = ai.metaData;
                    if (bundle != null) {
                        this.gameID = bundle.getString(GAME_KEY);
                        this.saveData();
                    }
                }
                catch (Exception ai) {
                    // empty catch block
                }
                if (this.gameID == null || this.gameID.isEmpty()) {
                    L.e(TAG, String.format("GameID is not set! Add <meta-data android:name=\"%s\" android:value=\"YOUR_GAME_ID\" /> to AndroidManifest.xml", GAME_KEY));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

