/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.async;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.async.NotificationTaskListener;
import com.gameofwhales.sdk.util.Utils;
import java.util.UUID;

public class NotificationTask
extends AsyncTask<Void, Void, Void> {
    private static String TAG = "GOW.NotificationTask";
    Bundle extras;
    Context context;
    Bitmap bigImage = null;
    NotificationTaskListener listener;

    public NotificationTask(Context context, Bundle extras, NotificationTaskListener listener) {
        try {
            this.extras = extras;
            this.listener = listener;
            this.context = context;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        block12: {
            try {
                L.e(TAG, "show");
                String subtitle = this.extras.getString("subtitle");
                String title = this.extras.getString("title");
                String smallIcon = this.extras.getString("smallIcon");
                String gowImage = this.extras.getString("gow_img");
                String tickerText = this.extras.getString("tickerText");
                String collapseKey = this.extras.getString("collapse_key");
                String packageName = this.context.getPackageName();
                Intent notificationIntent = this.context.getPackageManager().getLaunchIntentForPackage(packageName);
                notificationIntent.putExtras(this.extras);
                PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)notificationIntent, (int)0x10000000);
                if (gowImage != null && !gowImage.isEmpty()) {
                    this.bigImage = Utils.FetchBitmap(gowImage);
                }
                int iconID = 0;
                if (smallIcon != null && !smallIcon.isEmpty()) {
                    iconID = this.context.getResources().getIdentifier(smallIcon, "drawable", this.context.getPackageName());
                }
                if (iconID == 0) {
                    try {
                        int appIconResId;
                        PackageManager pm = this.context.getPackageManager();
                        ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 128);
                        iconID = appIconResId = applicationInfo.icon;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                L.i(TAG, "Version:" + Build.VERSION.SDK_INT);
                if (Build.VERSION.SDK_INT >= 26) {
                    L.i(TAG, "Build.VERSION.SDK_INT greater 25");
                    String id2 = "gow_channel_01";
                    NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
                    try {
                        String name = title;
                        String description = subtitle;
                        int importance = 4;
                        NotificationChannel mChannel = new NotificationChannel(id2, (CharSequence)name, importance);
                        mChannel.setDescription(description);
                        mChannel.enableLights(true);
                        mChannel.setLightColor(-65536);
                        mChannel.enableVibration(true);
                        mChannel.setVibrationPattern(new long[]{500L, 1000L});
                        mNotificationManager.createNotificationChannel(mChannel);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Uri notificationSound = RingtoneManager.getActualDefaultRingtoneUri((Context)this.context, (int)2);
                    int ncode = 101;
                    Notification.Builder builder = new Notification.Builder(this.context, id2);
                    builder.setContentTitle((CharSequence)title);
                    builder.setContentText((CharSequence)subtitle);
                    builder.setContentIntent(contentIntent);
                    if (this.bigImage != null) {
                        Notification.BigPictureStyle style = new Notification.BigPictureStyle();
                        style.setBigContentTitle((CharSequence)title);
                        style.setSummaryText((CharSequence)subtitle);
                        style.bigPicture(this.bigImage);
                        builder.setStyle((Notification.Style)style);
                    }
                    builder.setBadgeIconType(iconID);
                    builder.setSound(notificationSound);
                    builder.setSmallIcon(iconID);
                    builder.setAutoCancel(true);
                    mNotificationManager.notify(101, builder.build());
                    break block12;
                }
                L.i(TAG, "Build.VERSION.SDK_INT lower 26");
                NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context);
                builder.setContentIntent(contentIntent).setAutoCancel(true).setSmallIcon(iconID).setTicker((CharSequence)tickerText).setContentTitle((CharSequence)title).setPriority(2).setContentText((CharSequence)subtitle);
                Uri notificationSound = RingtoneManager.getActualDefaultRingtoneUri((Context)this.context, (int)2);
                builder.setSound(notificationSound);
                builder.setVibrate(new long[]{500L, 1000L});
                L.i(TAG, "Before if");
                if (this.bigImage != null) {
                    L.i(TAG, "has big image");
                    NotificationCompat.BigPictureStyle notificationStyle = new NotificationCompat.BigPictureStyle();
                    notificationStyle.setSummaryText((CharSequence)subtitle);
                    notificationStyle.setBigContentTitle((CharSequence)title);
                    notificationStyle.bigPicture(this.bigImage);
                    builder.setStyle((NotificationCompat.Style)notificationStyle);
                }
                L.i(TAG, "show notif");
                Notification notification = builder.build();
                NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
                notificationManager.notify(UUID.randomUUID().hashCode(), notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Void doInBackground(Void ... params) {
        try {
            this.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onPostExecute(Void param) {
        try {
            if (this.listener != null) {
                this.listener.onCompleted();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

