/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.Context;
import android.os.Bundle;
import com.gameofwhales.sdk.L;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GCMHelper {
    private static final String TAG = "GCMHelper";
    private static final String INSTANCE_ID_SCOPE = "GCM";
    private static final String REF_FULL_CLASS_GoogleCloudMessaging = "com.google.android.gms.gcm.GoogleCloudMessaging";
    private static final String REF_FULL_CLASS_InstanceID = "com.google.android.gms.iid.InstanceID";
    Class<?> CloudMessaging = null;
    Class<?> InstanceID = null;
    String androidID = null;

    public GCMHelper(String androidID) {
        try {
            this.androidID = androidID;
            try {
                this.CloudMessaging = Class.forName(REF_FULL_CLASS_GoogleCloudMessaging);
                this.InstanceID = Class.forName(REF_FULL_CLASS_InstanceID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.CloudMessaging == null) {
                L.w(TAG, "GCM cannot be requested. Class com.google.android.gms.gcm.GoogleCloudMessaging not found");
            } else if (this.InstanceID == null) {
                L.w(TAG, "GCM cannot be requested. Class com.google.android.gms.iid.InstanceID not found");
            } else if (this.androidID == null || this.androidID.isEmpty()) {
                L.w(TAG, "GCM cannot be requested. Android campaign not set.");
            } else {
                L.i(TAG, "GCM can be requested.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isGCMAvailable() {
        return this.androidID != null && !this.androidID.isEmpty() && this.CloudMessaging != null && this.InstanceID != null;
    }

    public String requestToken(Context context) {
        try {
            if (this.isGCMAvailable()) {
                try {
                    Method getInstance = this.InstanceID.getMethod("getInstance", Context.class);
                    Object instance = getInstance.invoke(null, context);
                    Method getToken = this.InstanceID.getMethod("getToken", String.class, String.class, Bundle.class);
                    Object tokenObj = getToken.invoke(instance, this.androidID, INSTANCE_ID_SCOPE, null);
                    String token = (String)tokenObj;
                    return token;
                }
                catch (NoSuchMethodException e) {
                    L.e(TAG, "Error while getting GCM token (NoSuchMethodException)");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    L.e(TAG, "[2] Error while getting GCM token (IllegalAccessException)");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    L.e(TAG, "[3] Error while getting GCM token (InvocationTargetException)");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    L.e(TAG, "[4] Error while getting GCM token (Exception)");
                    e.printStackTrace();
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

