/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import org.json.JSONObject;

public class GOWBroadcast
extends BroadcastReceiver {
    static final String TAG = "GOWBroadcast";
    static final String BROADCAST_MESSAGE_ACTION = "com.gameofwhales.action.Response";
    static final String BR_GOW_INITSTATUS_REQUEST = "com.gameofwhales.initstatus.request";
    static final String BR_GOW_ADSHOW_REQUEST = "com.gameofwhales.ad.show.request";
    static final String BR_GOW_USERSTATUS_REQUEST = "com.gameofwhales.userstatus.request";
    static final String BR_GOW_INIT_FINISHED = "com.gameofwhales.initfinish";
    static final String BR_GOW_USER_STATUS = "com.gameofwhales.userstatus";
    static final String MSG_TYPE = "gow_type";
    static final String DATA_AD_ENABLED = "adsEnabled";
    static final String DATA_AD_PRICE = "price";
    static final String DATA_AD_TYPE = "type";
    static final String DATA_AD_UNIT_TYPE = "adUnitType";
    static final String DATA_AD_PLATFORM = "adPlatform";

    public void onReceive(Context context, Intent intent) {
        try {
            L.d(TAG, "INTERNAL OnBroadcastReceive:" + intent.toString());
            String msgType = intent.getExtras().getString(MSG_TYPE);
            if (msgType.equals(BR_GOW_INITSTATUS_REQUEST) && GameOfWhales.IsSdkInitalized()) {
                GOWBroadcast.BroadcastSDKInitFinish(context);
            }
            if (msgType.equals(BR_GOW_ADSHOW_REQUEST)) {
                Double price = intent.getExtras().getDouble(DATA_AD_PRICE);
                String type = intent.getExtras().getString(DATA_AD_TYPE);
                String adUnitType = intent.getExtras().getString(DATA_AD_UNIT_TYPE);
                String adPlatform = intent.getExtras().getString(DATA_AD_PLATFORM);
                if (adPlatform == null || adPlatform.isEmpty()) {
                    adPlatform = "fyber";
                }
                if (GameOfWhales.IsSdkInitalized()) {
                    GameOfWhales.getInstance().extAdAction(price, adPlatform, type, adUnitType);
                }
            }
            if (msgType.equals(BR_GOW_USERSTATUS_REQUEST)) {
                GOWBroadcast.BroadcastUserStatus(context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Broadcast(Context context, Intent intent) {
        context.sendBroadcast(intent);
    }

    public static void BroadcastUserStatus(Context context) {
        try {
            GameOfWhales instance = GameOfWhales.getInstance();
            if (instance == null) {
                Log.w((String)TAG, (String)"BroadcastUserStatus: GameOfWhales instance is null");
                return;
            }
            JSONObject props = instance.GetProperties();
            boolean adsEnabled = true;
            if (props.has(DATA_AD_ENABLED)) {
                adsEnabled = props.getBoolean(DATA_AD_ENABLED);
            }
            Intent intent = new Intent();
            intent.setPackage(context.getPackageName());
            intent.setAction(BROADCAST_MESSAGE_ACTION);
            intent.putExtra(MSG_TYPE, BR_GOW_USER_STATUS);
            intent.putExtra(DATA_AD_ENABLED, adsEnabled);
            GOWBroadcast.Broadcast(context, intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void BroadcastSDKInitFinish(Context context) {
        try {
            Intent intent = new Intent();
            intent.setPackage(context.getPackageName());
            intent.setAction(BROADCAST_MESSAGE_ACTION);
            intent.putExtra(MSG_TYPE, BR_GOW_INIT_FINISHED);
            GOWBroadcast.Broadcast(context, intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

