/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.protocol.commands.Command;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Utils {
    public static Map<String, Object> jsonToMap(JSONObject json) throws Exception {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JSONObject.NULL) {
            retMap = Utils.toMap(json);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = Utils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = Utils.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = Utils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = Utils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static JSONArray CommandsToJSONArray(List<Command> commands) {
        JSONArray array = new JSONArray();
        if (commands == null) {
            L.e("ContentValues", "Commands is null from: CommandsToJSONArray");
            return array;
        }
        for (Command command : commands) {
            if (command == null) continue;
            JSONObject object = command.getArgs();
            if (object != null) {
                array.put((Object)object);
                continue;
            }
            Log.e((String)"GameOfWhales::Request", (String)"Some command is null");
        }
        return array;
    }

    public static boolean IsOnline(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnectedOrConnecting();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

