/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol;

import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SpecialOfferData {
    private static final String TAG = "GOW.SpecialOfferData";
    private String camp;
    private List<String> products = new ArrayList<String>();
    private float priceFactor = 1.0f;
    private float countFactor = 1.0f;
    private boolean redeemable = true;
    private Date finishedAt;
    private boolean used = false;
    private String payload;
    private Map<String, Object> customValues = new HashMap<String, Object>();

    public SpecialOfferData(JSONObject json) {
        try {
            this.camp = json.getString("camp");
            this.priceFactor = (float)json.getDouble("priceFactor");
            this.countFactor = (float)json.getDouble("countFactor");
            this.redeemable = json.getBoolean("redeemable");
            this.finishedAt = new Date(json.getLong("finishedAt"));
            this.payload = json.getString("payload");
            if (json.has("used")) {
                this.used = json.getBoolean("used");
            }
            if (json.has("custom")) {
                JSONObject custom = json.getJSONObject("custom");
                Iterator customKeys = custom.keys();
                while (customKeys.hasNext()) {
                    String key = (String)customKeys.next();
                    Object value = custom.get(key);
                    this.customValues.put(key, value);
                }
            }
            JSONArray jsproducts = json.getJSONArray("products");
            for (int i = 0; i < jsproducts.length(); ++i) {
                String id = jsproducts.getString(i);
                this.products.add(id);
            }
        }
        catch (JSONException e) {
            L.e(TAG, e.getMessage());
        }
    }

    public String save() {
        try {
            JSONObject args = new JSONObject();
            args.put("camp", (Object)this.camp);
            args.put("priceFactor", (double)this.priceFactor);
            args.put("countFactor", (double)this.countFactor);
            args.put("redeemable", this.redeemable);
            args.put("finishedAt", this.finishedAt.getTime());
            args.put("used", this.used);
            args.put("payload", (Object)this.payload);
            JSONArray jsproducts = new JSONArray();
            for (String product : this.products) {
                jsproducts.put((Object)product);
            }
            args.put("products", (Object)jsproducts);
            return args.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> getCustomValues() {
        return this.customValues;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean value) {
        this.used = value;
    }

    public String getId() {
        if (this.camp == null) {
            return "";
        }
        return this.camp;
    }

    public Date getFinishedAt() {
        if (this.finishedAt == null) {
            return new Date(0L);
        }
        return this.finishedAt;
    }

    public List<String> getProducts() {
        return this.products;
    }

    public float getPriceFactor() {
        return this.priceFactor;
    }

    public float getCountFactor() {
        return this.countFactor;
    }

    public boolean isExpired() {
        return this.getLeftTime() <= 0L;
    }

    public String getPayload() {
        return this.payload;
    }

    public long getLeftTime() {
        if (this.finishedAt == null) {
            return -1L;
        }
        return this.finishedAt.getTime() - GameOfWhales.GetServerTime();
    }

    public boolean isRedeemable() {
        return this.redeemable;
    }
}

