/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import com.gameofwhales.sdk.CommandQueue;
import com.gameofwhales.sdk.GameOfWhalesListener;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.SpecialOffer;
import com.gameofwhales.sdk.async.AdverstingIDAsyncTask;
import com.gameofwhales.sdk.async.AdverstingIDAsyncTaskListener;
import com.gameofwhales.sdk.protocol.Product;
import com.gameofwhales.sdk.protocol.SpecialOfferData;
import com.gameofwhales.sdk.protocol.commands.Command;
import com.gameofwhales.sdk.protocol.commands.ConvertingCommand;
import com.gameofwhales.sdk.protocol.commands.ErrorCommand;
import com.gameofwhales.sdk.protocol.commands.LoginCommand;
import com.gameofwhales.sdk.protocol.commands.ProfileCommand;
import com.gameofwhales.sdk.protocol.commands.PushDeliveredCommand;
import com.gameofwhales.sdk.protocol.commands.PushReactedCommand;
import com.gameofwhales.sdk.protocol.commands.ReceiptCommand;
import com.gameofwhales.sdk.protocol.commands.TokenCommand;
import com.gameofwhales.sdk.util.ActivityLyfecycleListener;
import com.gameofwhales.sdk.util.CommandListener;
import com.gameofwhales.sdk.util.DataStorage;
import com.gameofwhales.sdk.util.DelayedNofification;
import com.gameofwhales.sdk.util.GOWGCMService;
import com.gameofwhales.sdk.util.RequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GameOfWhales {
    public static String platform = "android";
    public static String VERSION;
    private static final String VERSION_SDK;
    public static final String CAMPAIGN_ID = "camp";
    public static final String PUSH_GOW = "gowpush";
    private static final String TAG = "GameOfWhales";
    public static final String STORE_SAMSUNG = "SamsungApps";
    public static final String STORE_GOOGLEPLAY = "GooglePlay";
    public static final String PROVIDER_FCM = "fcm";
    public static final String PROVIDER_GCM = "gcm";
    public static final String VERIFY_STATE_LEGAL = "legal";
    public static final String VERIFY_STATE_ILLEGAL = "illegal";
    public static final String VERIFY_STATE_UNDEFINED = "undefined";
    public static final String INTENT_ANDROID_ID = "androidID";
    private static final int BATCHING_DELAY = 30000;
    private static GameOfWhales INSTANCE;
    private final Activity activity;
    private CommandQueue queue;
    private Set<String> segments = new HashSet<String>();
    private Set<GameOfWhalesListener> listeners = new HashSet<GameOfWhalesListener>();
    private Map<String, Product> products = new HashMap<String, Product>();
    private List<SpecialOfferData> specialOfferData = new ArrayList<SpecialOfferData>();
    private Map<String, SpecialOffer> activeOffers = new HashMap<String, SpecialOffer>();
    private DataStorage data;
    private ActivityLyfecycleListener cycleListener;
    private Handler batchingHandler = new Handler();
    private Intent lastIntent;
    private List<DelayedNofification> delayedNofifications = new ArrayList<DelayedNofification>();
    private CommandListener commandListener = new CommandListener(){

        @Override
        public void onCommandResponse(Command command, JSONObject response) {
            GameOfWhales.this.onCommandResponse(command, response);
        }
    };
    long _lastBatchTime = 0L;
    private Runnable updateRunner = new Runnable(){

        @Override
        public void run() {
            if (GameOfWhales.this.check("updateRunner run")) {
                return;
            }
            long current = System.currentTimeMillis();
            if (current - GameOfWhales.this._lastBatchTime > 30000L) {
                GameOfWhales.this._lastBatchTime = current;
                GameOfWhales.this.queue.tryToSendNext(false);
            }
            boolean offersChanged = false;
            Iterator it = GameOfWhales.this.activeOffers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                SpecialOffer rep = (SpecialOffer)entry.getValue();
                if (rep == null) {
                    L.e(GameOfWhales.TAG, "rep is null from: updateRunner");
                    continue;
                }
                if (!rep.isExpired()) continue;
                offersChanged = true;
                it.remove();
                GameOfWhales.this.onDisappeared(rep);
            }
            if (offersChanged) {
                GameOfWhales.this.updateSpecialOffers();
            }
            GameOfWhales.this.runUpdate();
        }
    };

    private GameOfWhales(Activity activity, String gameID, String store, GameOfWhalesListener listener) {
        Log.i((String)TAG, (String)("Initializing GameOfWhales [" + VERSION_SDK + " android / " + VERSION + " " + platform + "]"));
        this.activity = activity;
        RequestBuilder.LOCALE = activity.getResources().getConfiguration().locale.getISO3Language();
        RequestBuilder.app_version = this.GetAppVersion();
        this.data = new DataStorage((Context)activity, gameID, store);
        this.queue = new CommandQueue(activity, this.data, this.commandListener);
        this.cycleListener = new ActivityLyfecycleListener();
        activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.cycleListener);
        if (listener != null) {
            this.addListener(listener);
        }
        if (this.data.getAdvID().isEmpty()) {
            AdverstingIDAsyncTask advTask = new AdverstingIDAsyncTask((Context)activity, new AdverstingIDAsyncTaskListener(){

                @Override
                public void onSuccess(String id) {
                    if (GameOfWhales.this.check("AdverstingIDAsyncTask onSuccess")) {
                        return;
                    }
                    GameOfWhales.this.data.setAdvID(id);
                    GameOfWhales.this.queue.tryToSendNext(false);
                    GameOfWhales.this.firstlogin();
                }

                @Override
                public void onFailure() {
                    if (GameOfWhales.this.check("AdverstingIDAsyncTask onFailure")) {
                        return;
                    }
                    String id = "gen-android-" + UUID.randomUUID().toString();
                    GameOfWhales.this.data.setAdvID(id);
                    GameOfWhales.this.queue.tryToSendNext(false);
                    GameOfWhales.this.firstlogin();
                }
            });
            if (Build.VERSION.SDK_INT >= 11) {
                advTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
            } else {
                advTask.execute(new Void[0]);
            }
        } else {
            this.firstlogin();
        }
        this.runUpdate();
        this.data.saveData();
    }

    public static boolean IsPushNotificationEnabled() {
        if (GameOfWhales.instanceCheck("IsPushNotificationEnabled")) {
            return INSTANCE.isPushNotificationEnabled();
        }
        return false;
    }

    public boolean isPushNotificationEnabled() {
        return this.data.isNotificationsEnable();
    }

    public static void SetPushNotificationsEnable(boolean value) {
        if (GameOfWhales.instanceCheck("SetPushNotificationsEnable")) {
            INSTANCE.setPushNotificationsEnable(value);
        }
    }

    public void setPushNotificationsEnable(boolean value) {
        if (value == this.data.isNotificationsEnable()) {
            return;
        }
        this.data.setNotificationsEnable(value);
        if (value) {
            this.updateToken(this.data.getToken(), this.data.getProvider());
        } else {
            this.updateToken("", PROVIDER_GCM);
        }
    }

    public static GameOfWhales getInstance() {
        return INSTANCE;
    }

    void firstlogin() {
        if (this.check("firstlogin")) {
            return;
        }
        this.login();
        this.readIntent();
        this.queue.tryToSendNext(false);
    }

    private void login() {
        if (this.check("login")) {
            return;
        }
        this.queue.add(new LoginCommand());
    }

    private Product getProduct(String sku) {
        if (this.check("getProduct")) {
            return null;
        }
        if (!this.products.containsKey(sku)) {
            this.products.put(sku, new Product(sku));
        }
        return this.products.get(sku);
    }

    private static boolean instanceCheck(String from) {
        if (INSTANCE == null) {
            L.e(TAG, from + ": GameOfWhales not initialized");
            return false;
        }
        return true;
    }

    public void pushDelivered(final String campID) {
        if (this.check("pushDelivered")) {
            return;
        }
        if (campID == null || campID.isEmpty()) {
            return;
        }
        if (this.data.isPushAlreadyDelivered(campID)) {
            L.w(TAG, "Push was already delivered: '" + campID + "'");
            return;
        }
        this.data.addDeliveredPush(campID);
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PushDeliveredCommand command = new PushDeliveredCommand(campID);
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    public static void PushDelivered(String campID) {
        if (GameOfWhales.instanceCheck("PushDelivered")) {
            INSTANCE.pushDelivered(campID);
        }
    }

    public void pushReacted(final String campID) {
        if (this.check("pushReacted")) {
            return;
        }
        if (campID == null || campID.isEmpty()) {
            return;
        }
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PushReactedCommand command = new PushReactedCommand(campID);
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    public static void PushReacted(String campID) {
        if (GameOfWhales.instanceCheck("PushReacted")) {
            INSTANCE.pushReacted(campID);
        }
    }

    public static void UpdateToken(String token, String provider) {
        if (GameOfWhales.instanceCheck("UpdateToken")) {
            INSTANCE.updateToken(token, provider);
        }
    }

    public static void ReportError(String message, String stacktrace) {
        if (GameOfWhales.instanceCheck("ReportError")) {
            INSTANCE.reportError(message, stacktrace);
        }
    }

    public void reportError(final String message, final String stacktrace) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ErrorCommand command = new ErrorCommand(message, stacktrace);
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    String GetAppVersion() {
        PackageManager m = this.activity.getPackageManager();
        String app_ver = "";
        try {
            app_ver = m.getPackageInfo((String)this.activity.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return app_ver;
    }

    public static void DetailsReceived(Bundle data) {
        if (GameOfWhales.instanceCheck("DetailsReceived")) {
            INSTANCE.detailsReceived(data);
        }
    }

    public static boolean IsAppForeground() {
        if (INSTANCE == null) {
            return false;
        }
        if (GameOfWhales.INSTANCE.cycleListener == null) {
            return false;
        }
        return GameOfWhales.INSTANCE.cycleListener.isForeground();
    }

    public static GameOfWhales Init(Activity activity, String gameID, String store, GameOfWhalesListener listener) {
        INSTANCE = new GameOfWhales(activity, gameID, store, listener);
        return INSTANCE;
    }

    public static GameOfWhales Init(Activity activity, String store, GameOfWhalesListener listener) {
        INSTANCE = new GameOfWhales(activity, null, store, listener);
        return INSTANCE;
    }

    public void addListener(GameOfWhalesListener listener) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: addListener");
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(GameOfWhalesListener listener) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: removeListener");
            return;
        }
        this.listeners.remove(listener);
    }

    private void readSpecialOffers(JSONObject object) throws Exception {
        if (object == null) {
            return;
        }
        String id = "specialOffers";
        if (!object.has("specialOffers")) {
            return;
        }
        L.i(TAG, "Reading spectial offers");
        JSONArray array = object.getJSONArray("specialOffers");
        this.specialOfferData.clear();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonSO = array.getJSONObject(i);
            SpecialOfferData so = new SpecialOfferData(jsonSO);
            this.specialOfferData.add(so);
        }
        this.updateSpecialOffers();
        this.checkDelayedNotifications();
    }

    public boolean hasSpecialOffer(String productID) {
        if (this.check("hasSpecialOffer")) {
            return false;
        }
        return this.activeOffers.get(productID) != null;
    }

    SpecialOffer getActiveOfferFor(String product) {
        if (this.check("getActiveOfferFor")) {
            return null;
        }
        return this.activeOffers.get(product);
    }

    SpecialOffer getSpecialOfferByCamp(String camp) {
        for (Map.Entry<String, SpecialOffer> entry : this.activeOffers.entrySet()) {
            SpecialOffer so = entry.getValue();
            if (!so.campaign.equals(camp)) continue;
            return so;
        }
        return null;
    }

    void updateSpecialOffers() {
        try {
            SpecialOffer specialOffer;
            HashSet<String> appeared = new HashSet<String>();
            ArrayList<String> removed = new ArrayList<String>();
            for (SpecialOfferData specialOfferData : this.specialOfferData) {
                if (specialOfferData == null || specialOfferData.isExpired() || this.isSpecialOfferUsed(specialOfferData.getId())) continue;
                List<String> products = specialOfferData.getProducts();
                for (String product : products) {
                    boolean add;
                    SpecialOffer currentActiveOffer = this.getActiveOfferFor(product);
                    boolean bl = add = currentActiveOffer == null;
                    if (currentActiveOffer != null) {
                        float newValue;
                        float activeValue = currentActiveOffer.priceFactor == 0.0f ? currentActiveOffer.countFactor : currentActiveOffer.countFactor / currentActiveOffer.priceFactor;
                        float f = newValue = specialOfferData.getPriceFactor() == 0.0f ? specialOfferData.getCountFactor() : specialOfferData.getCountFactor() / specialOfferData.getPriceFactor();
                        if (newValue > activeValue || currentActiveOffer.isExpired()) {
                            add = true;
                        }
                    }
                    if (!add) continue;
                    SpecialOffer offer = new SpecialOffer();
                    offer.campaign = specialOfferData.getId();
                    offer.product = product;
                    offer.priceFactor = specialOfferData.getPriceFactor();
                    offer.countFactor = specialOfferData.getCountFactor();
                    offer.finishedAt = specialOfferData.getFinishedAt();
                    offer.payload = specialOfferData.getPayload();
                    offer.redeemable = specialOfferData.isRedeemable();
                    offer.customValues = specialOfferData.getCustomValues();
                    this.activeOffers.put(product, offer);
                    appeared.add(product);
                }
            }
            for (Map.Entry entry : this.activeOffers.entrySet()) {
                SpecialOffer rep = (SpecialOffer)entry.getValue();
                boolean found = false;
                for (SpecialOfferData so : this.specialOfferData) {
                    if (so.isExpired() || this.isSpecialOfferUsed(so.getId())) continue;
                    for (String product : so.getProducts()) {
                        if (!product.equals(rep.product)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                removed.add(rep.product);
            }
            for (String string : removed) {
                specialOffer = this.getActiveOfferFor(string);
                this.activeOffers.remove(string);
                this.onDisappeared(specialOffer);
            }
            for (String string : appeared) {
                specialOffer = this.getActiveOfferFor(string);
                this.onAppeared(specialOffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printReport() {
        if (L.isDebug) {
            StringBuilder b = new StringBuilder();
            b.append("\nReport{");
            b.append(String.format("\n  Game id: %s", this.data.getGameID()));
            b.append(String.format("\n  Player id: %s", this.data.getAdvID()));
            b.append("\n  Segments:{");
            for (String seg : this.segments) {
                b.append("\n    " + seg);
            }
            b.append("\n  }");
            b.append("\n  SpecialOffers:{");
            for (SpecialOffer rep : this.getSpecialOffers()) {
                b.append("\n    " + rep.toString());
            }
            b.append("\n  }");
            b.append("\n}");
            L.d(TAG, b.toString());
        }
    }

    private void readVerifyState(JSONObject object) throws Exception {
        String purchases = "receipts";
        String transactionID = "transaction";
        String verifyState = "verifyState";
        if (!object.has("receipts")) {
            return;
        }
        L.i(TAG, "readVerifyState");
        JSONArray purchasesArray = object.getJSONArray("receipts");
        for (int i = 0; i < purchasesArray.length(); ++i) {
            JSONObject item = purchasesArray.getJSONObject(i);
            String tID = item.getString("transaction");
            String state = item.getString("verifyState");
            this.onPurchaseVerified(tID, state);
        }
    }

    private void readSegments(JSONObject object) throws Exception {
        if (object == null) {
            return;
        }
        String id = "segments";
        if (!object.has("segments")) {
            return;
        }
        JSONArray array = object.getJSONArray("segments");
        L.i(TAG, "Reading segments");
        this.segments.clear();
        for (int i = 0; i < array.length(); ++i) {
            String segment = array.getString(i);
            this.segments.add(segment);
        }
    }

    public static void DetailsFromString(String string) {
        if (GameOfWhales.instanceCheck("DetailsFromString")) {
            INSTANCE.detailsFromString(string);
        }
    }

    public void detailsFromString(String string) {
        try {
            string = string.substring(string.indexOf("{"));
            JSONObject json = new JSONObject(string);
            String sku = json.getString("productId");
            Product p = this.getProduct(sku);
            p.setDetails(json);
            this.updateSpecialOffers();
        }
        catch (Exception e) {
            L.e(TAG, "detailsFromString Exception");
            e.printStackTrace();
            return;
        }
    }

    public void detailsReceived(final Bundle data) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (GameOfWhales.this.check("detailsReceived")) {
                    return;
                }
                try {
                    int response = data.getInt("RESPONSE_CODE");
                    if (response != 0) {
                        L.e(GameOfWhales.TAG, "Query product error with response code " + response);
                        return;
                    }
                    ArrayList responseList = data.getStringArrayList("DETAILS_LIST");
                    for (String item : responseList) {
                        JSONObject json = new JSONObject(item);
                        String sku = json.getString("productId");
                        Product p = GameOfWhales.this.getProduct(sku);
                        p.setDetails(json);
                    }
                    GameOfWhales.this.updateSpecialOffers();
                }
                catch (Exception e) {
                    L.e(GameOfWhales.TAG, "detailsReceived Exception");
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    public static void InAppPurchased(String sku, double price, String currency, String transactionId, String receipt) {
        if (GameOfWhales.instanceCheck("InAppPurchased(full args)")) {
            INSTANCE.inAppPurchased(sku, price, currency, transactionId, receipt);
        }
    }

    public void inAppPurchased(final String sku, final double price, final String currency, final String transactionId, final String receipt) {
        if (this.check("inAppPurchased")) {
            return;
        }
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ReceiptCommand receiptCommand = new ReceiptCommand(transactionId, receipt.toString());
                SpecialOffer offer = GameOfWhales.this.getSpecialOffer(sku);
                if (offer != null) {
                    GameOfWhales.this.saveUsedSpecialOffer(offer);
                    receiptCommand.setCampaign(offer.campaign);
                    GameOfWhales.this.updateSpecialOffers();
                }
                receiptCommand.setPrice(price);
                receiptCommand.setCurrency(currency);
                GameOfWhales.this.queue.add(receiptCommand);
                GameOfWhales.this.queue.tryToSendNext(false);
            }
        });
    }

    public static void SetAndroidProjectID(String id) {
        if (GameOfWhales.instanceCheck("SetAndroidProjectID")) {
            INSTANCE.setAndroidProjectID(id);
        }
    }

    public void setAndroidProjectID(String id) {
        if (id == null || id.isEmpty()) {
            return;
        }
        L.i(TAG, "setAndroidProjectID: " + id);
        Intent intent = new Intent((Context)this.activity, GOWGCMService.class);
        intent.putExtra(INTENT_ANDROID_ID, id);
        this.activity.startService(intent);
    }

    public static void Acquire(String currency, long amount, String source, long number, String place) {
        if (GameOfWhales.instanceCheck("Acquire")) {
            INSTANCE.acquire(currency, amount, source, number, place);
        }
    }

    public void acquire(final String currency, final long amount, final String source, final long number, final String place) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Long> resources = new HashMap<String, Long>();
                resources.put(currency, amount);
                resources.put(source, -number);
                GameOfWhales.this.converting(resources, place);
            }
        });
    }

    public static void Consume(String currency, long number, String sink, long amount, String place) {
        if (GameOfWhales.instanceCheck("Consume")) {
            INSTANCE.consume(currency, number, sink, amount, place);
        }
    }

    public void consume(final String currency, final long number, final String sink, final long amount, final String place) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                HashMap<String, Long> resources = new HashMap<String, Long>();
                resources.put(currency, -number);
                resources.put(sink, amount);
                GameOfWhales.this.converting(resources, place);
            }
        });
    }

    public static void Converting(String resourcesJson, String place) {
        if (GameOfWhales.instanceCheck("Converting(String)")) {
            try {
                HashMap<String, Long> resources = new HashMap<String, Long>();
                JSONObject object = new JSONObject(resourcesJson);
                Iterator keysItr = object.keys();
                while (keysItr.hasNext()) {
                    String key = (String)keysItr.next();
                    Long value = object.getLong(key);
                    resources.put(key, value);
                }
                INSTANCE.converting(resources, place);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Converting(Map<String, Long> resources, String place) {
        if (GameOfWhales.instanceCheck("Converting(MAP)")) {
            INSTANCE.converting(resources, place);
        }
    }

    public void converting(final Map<String, Long> resources, final String place) {
        if (this.check("converting")) {
            return;
        }
        if (resources == null) {
            return;
        }
        if (resources.size() == 0) {
            return;
        }
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SpecialOffer offer;
                ConvertingCommand command = new ConvertingCommand(resources, place);
                ArrayList debits = new ArrayList();
                for (Map.Entry entry : resources.entrySet()) {
                    if ((Long)entry.getValue() <= 0L) continue;
                    debits.add(entry.getKey());
                }
                if (debits.size() == 1 && (offer = GameOfWhales.this.getSpecialOffer((String)debits.get(0))) != null) {
                    command.setCampaign(offer.campaign);
                    GameOfWhales.this.saveUsedSpecialOffer(offer);
                    GameOfWhales.this.updateSpecialOffers();
                }
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    public static void Profile(String paramsJson) {
        if (GameOfWhales.instanceCheck("Profile String")) {
            INSTANCE.profile(paramsJson);
        }
    }

    public static void Profile(Map<String, Object> params) {
        if (GameOfWhales.instanceCheck("Profile Map")) {
            INSTANCE.profile(params);
        }
    }

    public void readIntent() {
        L.i(TAG, "Read Intent : ");
        Intent intent = this.activity.getIntent();
        if (intent == null || intent.equals(this.lastIntent)) {
            L.i(TAG, "Same intent : ");
            return;
        }
        this.lastIntent = this.activity.getIntent();
        Bundle extras = this.activity.getIntent().getExtras();
        if (extras != null && extras.containsKey(CAMPAIGN_ID)) {
            String campID = extras.getString(CAMPAIGN_ID);
            L.i(TAG, "Campaign ID : " + campID);
            this.pushReacted(campID);
        }
    }

    public void onActivityResumed() {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                L.i(GameOfWhales.TAG, "onActivityResumed :");
                GameOfWhales.this.readIntent();
                GameOfWhales.this.queue.tryToSendNext(false);
            }
        });
    }

    public void profile(final String paramsJSON) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ProfileCommand command = new ProfileCommand(paramsJSON);
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    public void profile(final Map<String, Object> changes) {
        if (this.check("profile")) {
            return;
        }
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ProfileCommand command = new ProfileCommand(changes);
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    public static void InAppPurchased(String dataString, String signature) {
        if (GameOfWhales.instanceCheck("InAppPurchased(String data)")) {
            INSTANCE.inAppPurchased(dataString, signature);
        }
    }

    public void inAppPurchased(String data, String signature) {
        try {
            data = data.substring(data.indexOf("{"));
            JSONObject json = new JSONObject(data);
            String sku = json.getString("productId");
            String orderId = json.getString("orderId");
            Product product = this.getProduct(sku);
            try {
                double price = 0.0;
                String currency = "";
                if (product != null && product.hasDetails()) {
                    price = product.getDoublePrice();
                    currency = product.getPriceCurrencyCode();
                } else {
                    Log.e((String)TAG, (String)("Product has n price! Call 'detailsReceived' method before' : Data:" + data.toString()));
                }
                String receipt = GameOfWhales.BuildGooglePlayReceipt(data, signature);
                this.inAppPurchased(sku, price, currency, orderId, receipt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void InAppPurchased(Intent data) {
        if (GameOfWhales.instanceCheck("InAppPurchased(Intent data)")) {
            INSTANCE.inAppPurchased(data);
        }
    }

    public void inAppPurchased(final Intent data) {
        if (this.check("inAppPurchased")) {
            return;
        }
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    int responseCode = data.getIntExtra("RESPONSE_CODE", 0);
                    if (responseCode != 0) {
                        return;
                    }
                    String purchaseData = data.getStringExtra("INAPP_PURCHASE_DATA");
                    String dataSignature = data.getStringExtra("INAPP_DATA_SIGNATURE");
                    JSONObject jo = new JSONObject(purchaseData);
                    String sku = jo.getString("productId");
                    Product product = GameOfWhales.this.getProduct(sku);
                    try {
                        JSONObject payload = new JSONObject();
                        payload.put("json", (Object)purchaseData);
                        payload.put("signature", (Object)dataSignature);
                        JSONObject receipt = new JSONObject(purchaseData);
                        String transactionId = receipt.getString("purchaseToken");
                        receipt.put("Store", (Object)GameOfWhales.STORE_GOOGLEPLAY);
                        receipt.put("TransactionID", (Object)transactionId);
                        receipt.put("Payload", (Object)payload.toString());
                        double price = 0.0;
                        String currency = "";
                        if (product != null && product.hasDetails()) {
                            price = product.getDoublePrice();
                            currency = product.getPriceCurrencyCode();
                        } else {
                            Log.e((String)GameOfWhales.TAG, (String)("Product has n price! Call 'detailsReceived' method before' : Data:" + data.toString()));
                        }
                        GameOfWhales.this.inAppPurchased(sku, price, currency, transactionId, receipt.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void updateToken(final String token, final String provider) {
        if (token == null || token.isEmpty()) {
            return;
        }
        if (provider == null || provider.isEmpty()) {
            return;
        }
        if (this.check("updateToken")) {
            return;
        }
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!token.isEmpty()) {
                    GameOfWhales.this.data.setToken(token);
                    GameOfWhales.this.data.setProvider(provider);
                }
                TokenCommand command = new TokenCommand(token, provider);
                GameOfWhales.this.queue.add(command);
            }
        });
    }

    public static SpecialOffer GetSpecialOffer(String productID) {
        if (GameOfWhales.instanceCheck("GetSpecialOffer")) {
            return INSTANCE.getSpecialOffer(productID);
        }
        return null;
    }

    public boolean hasSpecialOffers() {
        if (this.check("hasSpecialOffers")) {
            return false;
        }
        return this.activeOffers.size() > 0;
    }

    public Iterable<SpecialOffer> getSpecialOffers() {
        if (this.check("getSpecialOffers")) {
            return null;
        }
        return this.activeOffers.values();
    }

    public SpecialOffer getSpecialOffer(String productID) {
        return this.getActiveOfferFor(productID);
    }

    private void onAppeared(SpecialOffer specialOffer) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onAppeared");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSpecialOfferAppeared(specialOffer);
        }
    }

    private void onDisappeared(SpecialOffer specialOffer) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onPurchaseVerified");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onSpecialOfferDisappeared(specialOffer);
        }
    }

    private void onPurchaseVerified(String transactionID, String state) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: onPurchaseVerified");
            return;
        }
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onPurchaseVerified(transactionID, state);
        }
    }

    public void notifyPushDelivered(boolean isOffer, String campID, String title, String message) {
        if (this.listeners == null) {
            L.e(TAG, "Listeners is null from: notifyPushDelivered");
            return;
        }
        try {
            SpecialOffer so = null;
            if (isOffer && (so = this.getSpecialOfferByCamp(campID)) == null) {
                DelayedNofification dn = new DelayedNofification();
                dn.camp = campID;
                dn.title = title;
                dn.messasge = message;
                this.delayedNofifications.add(dn);
                this.queue.tryToSendNext(true);
                return;
            }
            this.notifyPushDeliveredWithOffer(so, campID, title, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkDelayedNotifications() {
        HashMap<String, DelayedNofification> notifications = new HashMap<String, DelayedNofification>();
        for (Map.Entry<String, SpecialOffer> entry : this.activeOffers.entrySet()) {
            SpecialOffer so = entry.getValue();
            for (DelayedNofification dn : this.delayedNofifications) {
                if (!so.campaign.equals(dn.camp)) continue;
                dn.offer = so;
                notifications.put(so.campaign, dn);
            }
        }
        for (Map.Entry<String, SpecialOffer> entry : notifications.entrySet()) {
            DelayedNofification dn = (DelayedNofification)((Object)entry.getValue());
            this.delayedNofifications.remove(dn);
            this.notifyPushDeliveredWithOffer(dn.offer, dn.camp, dn.title, dn.messasge);
        }
    }

    private void notifyPushDeliveredWithOffer(SpecialOffer offer, String campID, String title, String message) {
        for (GameOfWhalesListener listener : this.listeners) {
            if (listener == null) continue;
            listener.onPushDelivered(offer, campID, title, message);
        }
    }

    private void onCommandResponse(Command command, JSONObject response) {
        if (response == null) {
            return;
        }
        L.i(TAG, "onCommandResponse: " + response.toString());
        try {
            this.readSegments(response);
            this.readSpecialOffers(response);
            this.readVerifyState(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveUsedSpecialOffer(SpecialOffer offer) {
        if (this.check("saveUsedSpecialOffer")) {
            return;
        }
        for (SpecialOfferData ofdata : this.specialOfferData) {
            if (!ofdata.getId().equals(offer.campaign) || !ofdata.isRedeemable()) continue;
            ofdata.setUsed(true);
            this.data.addSpecialOffer(ofdata);
        }
    }

    private boolean isSpecialOfferUsed(String campaingID) {
        if (this.check("isSpecialOfferUsed")) {
            return false;
        }
        SpecialOfferData ofdata = this.data.getSpecialOffer(campaingID);
        if (ofdata != null) {
            return ofdata.isUsed();
        }
        return false;
    }

    private void runUpdate() {
        if (this.batchingHandler == null) {
            L.e(TAG, "batchingHandler is null, from run update");
            return;
        }
        this.batchingHandler.postDelayed(this.updateRunner, 1L);
    }

    private boolean check(String from) {
        if (this.queue == null) {
            L.e(TAG, "Queue is null from: " + from);
            return true;
        }
        if (this.activeOffers == null) {
            L.e(TAG, "Active Offers is null from: " + from);
            return true;
        }
        if (this.data == null) {
            L.e(TAG, "Data is null from: " + from);
            return true;
        }
        if (this.specialOfferData == null) {
            L.e(TAG, "specialOfferData is null from: " + from);
            return true;
        }
        if (this.products == null) {
            L.e(TAG, "products is null from: " + from);
            return true;
        }
        return false;
    }

    public static void SubscribeErrors() {
        L.d(TAG, "ErrorsSubscribe");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread paramThread, Throwable paramThrowable) {
                if (GameOfWhales.instanceCheck("uncaughtException")) {
                    L.d(GameOfWhales.TAG, "uncaughtException");
                    StackTraceElement[] elements = paramThrowable.getStackTrace();
                    String stacktrace = "";
                    for (StackTraceElement el : elements) {
                        stacktrace = stacktrace + el.toString() + "\n";
                    }
                    ErrorCommand command = new ErrorCommand(paramThrowable.getMessage(), stacktrace);
                    INSTANCE.data.addCommand(command);
                    Intent intent = new Intent((Context)INSTANCE.activity, INSTANCE.activity.getClass());
                    INSTANCE.activity.startActivity(intent);
                    Process.killProcess((int)Process.myPid());
                    System.exit(0);
                }
            }
        });
    }

    public static String BuildGooglePlayReceipt(String origJson, String signature) {
        JSONObject object = new JSONObject();
        try {
            JSONObject payload = new JSONObject();
            payload.put("json", (Object)origJson);
            payload.put("signature", (Object)signature);
            JSONObject receipt = new JSONObject(origJson);
            String transactionId = receipt.getString("purchaseToken");
            receipt.put("Store", (Object)STORE_GOOGLEPLAY);
            receipt.put("TransactionID", (Object)transactionId);
            receipt.put("Payload", (Object)payload.toString());
            return receipt.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return object.toString();
        }
    }

    public static String BuildSamsungReceipt(String paymentID, String purchaseID) {
        JSONObject object = new JSONObject();
        JSONObject payload = new JSONObject();
        try {
            object.put("Store", (Object)STORE_SAMSUNG);
            object.put("TransactionID", (Object)paymentID);
            payload.put("purchaseId", (Object)purchaseID);
            object.put("Payload", (Object)payload.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    static {
        VERSION_SDK = VERSION = "2.0.15";
    }
}

