/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.async;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import com.gameofwhales.sdk.async.NotificationTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;

public class NotificationTask
extends AsyncTask<Void, Void, Void> {
    private static String TAG = "GOW.NotificationTask";
    Bundle extras;
    Context context;
    Bitmap bigImage = null;
    NotificationTaskListener listener;

    public NotificationTask(Context context, Bundle extras, NotificationTaskListener listener) {
        this.extras = extras;
        this.listener = listener;
        this.context = context;
    }

    public void show() {
        try {
            String subtitle = this.extras.getString("subtitle");
            String title = this.extras.getString("title");
            String smallIcon = this.extras.getString("smallIcon");
            String gowImage = this.extras.getString("gow_img");
            String tickerText = this.extras.getString("tickerText");
            String collapseKey = this.extras.getString("collapse_key");
            String packageName = this.context.getPackageName();
            Intent notificationIntent = this.context.getPackageManager().getLaunchIntentForPackage(packageName);
            notificationIntent.putExtras(this.extras);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)notificationIntent, (int)0x10000000);
            if (gowImage != null && !gowImage.isEmpty()) {
                this.fetchBitmap(gowImage);
            }
            int iconID = 0;
            if (smallIcon != null && !smallIcon.isEmpty()) {
                iconID = this.context.getResources().getIdentifier(smallIcon, "drawable", this.context.getPackageName());
            }
            if (iconID == 0) {
                try {
                    int appIconResId;
                    PackageManager pm = this.context.getPackageManager();
                    ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 128);
                    iconID = appIconResId = applicationInfo.icon;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context);
            builder.setContentIntent(contentIntent).setAutoCancel(true).setSmallIcon(iconID).setTicker((CharSequence)tickerText).setContentTitle((CharSequence)title).setContentText((CharSequence)subtitle);
            Uri notificationSound = RingtoneManager.getActualDefaultRingtoneUri((Context)this.context, (int)2);
            builder.setSound(notificationSound);
            builder.setVibrate(new long[]{500L, 1000L});
            if (this.bigImage != null) {
                NotificationCompat.BigPictureStyle notificationStyle = new NotificationCompat.BigPictureStyle();
                notificationStyle.setSummaryText((CharSequence)subtitle);
                notificationStyle.setBigContentTitle((CharSequence)title);
                notificationStyle.bigPicture(this.bigImage);
                builder.setStyle((NotificationCompat.Style)notificationStyle);
            }
            Notification notification = builder.build();
            NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.context);
            notificationManager.notify(UUID.randomUUID().hashCode(), notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Void doInBackground(Void ... params) {
        this.show();
        return null;
    }

    protected void onPostExecute(Void param) {
        if (this.listener != null) {
            this.listener.onCompleted();
        }
    }

    private boolean fetchBitmap(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = null;
            connection = urlString.toLowerCase().startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            this.bigImage = BitmapFactory.decodeStream((InputStream)input);
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error while getting bitmap from: " + urlString));
            e.printStackTrace();
            return false;
        }
    }
}

