/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.protocol;

import com.gameofwhales.sdk.L;
import org.json.JSONObject;

public class Product {
    private static String TAG = "GOW.Product";
    private String sku;
    private String type;
    private String price;
    private long priceAmountMicros;
    private String priceCurrencyCode;
    private String title;
    private String description;
    private JSONObject originalData;

    public JSONObject getOriginalData() {
        return this.originalData;
    }

    public Product setDetails(JSONObject json) {
        this.originalData = json;
        try {
            String detailsSku = json.getString("productId");
            if (!this.sku.isEmpty() && !this.sku.equals(detailsSku)) {
                L.e(TAG, "On SetDetails: skus does not match");
                return this;
            }
            this.type = json.getString("type");
            this.price = json.getString("price");
            this.priceAmountMicros = json.getLong("price_amount_micros");
            this.priceCurrencyCode = json.getString("price_currency_code");
            this.title = json.getString("title");
            this.description = json.getString("description");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public Product(String sku) {
        this.sku = sku;
    }

    public Product(JSONObject json) {
        this.setDetails(json);
    }

    public boolean hasDetails() {
        return this.price != null && !this.price.isEmpty() && this.priceCurrencyCode != null && !this.priceCurrencyCode.isEmpty();
    }

    public String getSku() {
        return this.sku;
    }

    public String getType() {
        return this.type;
    }

    public String getPrice() {
        return this.price;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public long getPriceAmountMicros() {
        return this.priceAmountMicros;
    }

    public String getPriceCurrencyCode() {
        return this.priceCurrencyCode;
    }

    public double getDoublePrice() {
        return (double)this.getPriceAmountMicros() * 1.0 / 1000000.0;
    }
}

