/*
 * Decompiled with CFR 0.152.
 */
package com.gameofwhales.sdk.async;

import android.content.Context;
import android.os.AsyncTask;
import com.gameofwhales.sdk.GameOfWhales;
import com.gameofwhales.sdk.L;
import com.gameofwhales.sdk.util.GCMHelper;

public class GCMAsyncTask
extends AsyncTask<Void, Void, String> {
    private static String TAG = "GCMAsyncTask";
    private String androidID;
    private Context context;

    public GCMAsyncTask(Context context, String androidID) {
        L.d(TAG, "GCMAsyncTask");
        this.androidID = androidID;
        this.context = context;
    }

    protected String doInBackground(Void ... params) {
        L.d(TAG, "doInBackground");
        try {
            if (GameOfWhales.getInstance() != null) {
                String token;
                GCMHelper gcm = new GCMHelper(this.androidID);
                if (gcm.isGCMAvailable() && (token = gcm.requestToken(this.context)) != null) {
                    return token;
                }
            } else {
                L.e(TAG, "GOW not initialized");
            }
        }
        catch (Exception e) {
            L.e(TAG, "Failed to handle token intent");
            e.printStackTrace();
        }
        return "";
    }

    protected void onPostExecute(String token) {
        L.d(TAG, "onPostExecute: " + token);
        if (token != null && !token.isEmpty()) {
            L.i(TAG, "New GCM token: " + token);
            GameOfWhales.getInstance().updateToken(token, "gcm");
        }
    }
}

