/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.colorscheme.ColorClassifier;
import com.galenframework.rainbow4j.filters.ImageFilter;
import com.galenframework.rainbow4j.filters.ReplaceColorsDefinition;
import java.awt.Color;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Predicate;

public class ReplaceColorsFilter
implements ImageFilter {
    private List<ReplaceColorsDefinition> replaceColorsDefinitions;

    public ReplaceColorsFilter(List<ReplaceColorsDefinition> replaceColorsDefinitions) {
        this.replaceColorsDefinitions = replaceColorsDefinitions;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        int ya = area.y;
        int yb = area.y + area.height;
        int xa = area.x;
        int xb = area.x + area.width;
        if (this.replaceColorsDefinitions != null && !this.replaceColorsDefinitions.isEmpty()) {
            for (int y = ya; y < yb; ++y) {
                for (int x = xa; x < xb; ++x) {
                    int k = y * width * 4 + x * 4;
                    int r = bytes.get(k) & 0xFF;
                    int g = bytes.get(k + 1) & 0xFF;
                    int b = bytes.get(k + 2) & 0xFF;
                    for (ReplaceColorsDefinition colorDefinition : this.replaceColorsDefinitions) {
                        if (colorDefinition.getColorClassifiers() == null) continue;
                        int maxColorDistance = colorDefinition.getTolerance() * colorDefinition.getTolerance() * 3;
                        if (!colorDefinition.getColorClassifiers().stream().filter(this.byHoldingColor(r, g, b, maxColorDistance)).findAny().isPresent()) continue;
                        Color replaceColor = colorDefinition.getReplaceColor();
                        int radius = colorDefinition.getRadius();
                        for (int yr = Math.max(y - radius, ya); yr <= Math.min(y + radius, yb - 1); ++yr) {
                            for (int xr = Math.max(x - radius, xa); xr <= Math.min(x + radius, xb - 1); ++xr) {
                                k = yr * width * 4 + xr * 4;
                                bytes.put(k, (byte)replaceColor.getRed());
                                bytes.put(k + 1, (byte)replaceColor.getGreen());
                                bytes.put(k + 2, (byte)replaceColor.getBlue());
                            }
                        }
                    }
                }
            }
        }
    }

    private Predicate<ColorClassifier> byHoldingColor(int r, int g, int b, int maxColorDistance) {
        return c -> c.holdsColor(r, g, b, maxColorDistance);
    }

    public List<ReplaceColorsDefinition> getReplaceColorsDefinitions() {
        return this.replaceColorsDefinitions;
    }

    public void setReplaceColorsDefinitions(List<ReplaceColorsDefinition> replaceColorsDefinitions) {
        this.replaceColorsDefinitions = replaceColorsDefinitions;
    }
}

