/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.ImageHandler;
import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;
import java.nio.ByteBuffer;

public class MaskFilter
implements ImageFilter {
    private final ImageHandler maskImage;

    public MaskFilter(ImageHandler maskImage) {
        this.maskImage = maskImage;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        ByteBuffer maskBytes = this.maskImage.getBytes();
        int maskWidth = this.maskImage.getWidth();
        int maskHeight = this.maskImage.getHeight();
        for (int y = area.y; y < area.y + area.height; ++y) {
            for (int x = area.x; x < area.x + area.width; ++x) {
                int averageMaskPixel;
                int k = y * width * 4 + x * 4;
                int maskX = x - area.x;
                int maskY = y - area.y;
                if (maskX < maskWidth && maskY < maskHeight) {
                    int m = maskY * maskWidth * 4 + maskX * 4;
                    averageMaskPixel = (maskBytes.get(m) + maskBytes.get(m + 1) + maskBytes.get(m + 2)) / 3;
                } else {
                    averageMaskPixel = 255;
                }
                bytes.put(k + 3, (byte)(Math.min(averageMaskPixel, 255) & 0xFF));
            }
        }
    }
}

