/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;
import java.nio.ByteBuffer;

public class ContrastFilter
implements ImageFilter {
    private int level;

    public ContrastFilter(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        if (this.level > 259) {
            this.level = 258;
        }
        int factor = 259 * (this.level + 255) / (255 * (259 - this.level));
        for (int y = area.y; y < area.y + area.height; ++y) {
            for (int x = area.x; x < area.x + area.width; ++x) {
                int k = y * width * 4 + x * 4;
                bytes.put(k, this.contrast(bytes.get(k), factor));
                bytes.put(k + 1, this.contrast(bytes.get(k + 1), factor));
                bytes.put(k + 2, this.contrast(bytes.get(k + 2), factor));
            }
        }
    }

    private byte contrast(byte color, int factor) {
        int colorInt = color & 0xFF;
        if ((colorInt = (colorInt - 128) * factor + 128) < 0) {
            colorInt = 0;
        } else if (colorInt > 255) {
            colorInt = 255;
        }
        return (byte)colorInt;
    }
}

