/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.xml;

import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class XmlBuilder {
    public static String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static String INDENTATION = "    ";
    private XmlNode rootNode;
    private String firstLine;

    public XmlBuilder(String firstLine, XmlNode rootNode) {
        this.firstLine = firstLine;
        this.rootNode = rootNode;
    }

    public static XmlNode node(String name) {
        return new XmlNode(name);
    }

    public String build() {
        StringWriter sw = new StringWriter();
        if (this.firstLine != null) {
            sw.append(this.firstLine);
            sw.append('\n');
        }
        this.rootNode.toXml("", sw);
        return sw.toString();
    }

    public static XmlNode textNode(String text) {
        return new XmlNode(text).asTextNode();
    }

    public static class XmlNode {
        private XmlNode parent;
        private XmlNodeType type = XmlNodeType.NODE;
        private List<Pair<String, String>> attributes = new LinkedList<Pair<String, String>>();
        private String name;
        private List<XmlNode> childNodes = new LinkedList<XmlNode>();

        public XmlNode(String name) {
            this.setName(name);
        }

        public XmlNode withAttribute(String name, String value) {
            this.getAttributes().add((Pair<String, String>)Pair.of((Object)name, (Object)value));
            return this;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public XmlNode getParent() {
            return this.parent;
        }

        public void setParent(XmlNode parent) {
            this.parent = parent;
        }

        public void add(XmlNode childNode) {
            childNode.parent = this;
            this.childNodes.add(childNode);
        }

        public void toXml(String indentation, StringWriter sw) {
            if (this.type == XmlNodeType.TEXT) {
                sw.append(StringEscapeUtils.escapeXml((String)this.name));
            } else if (this.type == XmlNodeType.TEXT_UNESCAPED) {
                sw.append(this.name);
            } else {
                if (this.parent != null) {
                    sw.append("\n");
                }
                sw.append(indentation);
                sw.append("<");
                sw.append(this.name);
                this.writeAttributes(sw);
                sw.append(">");
                this.writeChildren(indentation + INDENTATION, sw);
                if (this.childNodes != null && this.childNodes.size() > 0 && !this.containsOnlyText()) {
                    sw.append("\n");
                    sw.append(indentation);
                }
                sw.append("</");
                sw.append(this.name);
                sw.append(">");
            }
        }

        private boolean containsOnlyText() {
            return this.childNodes.size() == 1 && (this.childNodes.get(0).getType() == XmlNodeType.TEXT || this.childNodes.get(0).getType() == XmlNodeType.TEXT_UNESCAPED);
        }

        private void writeChildren(String indentation, StringWriter sw) {
            for (XmlNode childNode : this.childNodes) {
                childNode.toXml(indentation, sw);
            }
        }

        private void writeAttributes(StringWriter sw) {
            for (Pair<String, String> attribute : this.getAttributes()) {
                sw.append(' ');
                sw.append((CharSequence)attribute.getLeft());
                sw.append('=');
                sw.append('\"');
                sw.append(StringEscapeUtils.escapeXml((String)((String)attribute.getRight())));
                sw.append('\"');
            }
        }

        public List<Pair<String, String>> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(List<Pair<String, String>> attributes) {
            this.attributes = attributes;
        }

        public XmlNodeType getType() {
            return this.type;
        }

        public void setType(XmlNodeType type) {
            this.type = type;
        }

        public XmlNode asTextNode() {
            this.setType(XmlNodeType.TEXT);
            return this;
        }

        public XmlNode withChildren(XmlNode ... nodes) {
            for (XmlNode node : nodes) {
                this.add(node);
            }
            return this;
        }

        public XmlNode withText(String text) {
            this.add(XmlBuilder.node(text).asTextNode());
            return this;
        }

        public XmlNode withUnescapedText(String text) {
            this.add(XmlBuilder.node(text).asUnescapedTextNode());
            return this;
        }

        private XmlNode asUnescapedTextNode() {
            this.setType(XmlNodeType.TEXT_UNESCAPED);
            return this;
        }
    }

    public static enum XmlNodeType {
        NODE,
        TEXT,
        TEXT_UNESCAPED;

    }
}

