/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.SpecVertically;
import com.galenframework.validation.specs.SpecValidationAligned;

public class SpecValidationVertically
extends SpecValidationAligned<SpecVertically> {
    @Override
    protected String getAligmentText(SpecVertically spec) {
        return String.format("vertically %s", spec.getAlignment().toString());
    }

    @Override
    protected int getOffset(SpecVertically spec, PageElement mainObject, PageElement childObject) {
        Rect mainArea = mainObject.getArea();
        Rect childArea = childObject.getArea();
        switch (spec.getAlignment()) {
            case CENTERED: {
                return Math.abs(childArea.getLeft() + childArea.getWidth() / 2 - (mainArea.getLeft() + mainArea.getWidth() / 2));
            }
            case LEFT: {
                return Math.abs(childArea.getLeft() - mainArea.getLeft());
            }
            case RIGHT: {
                return Math.abs(childArea.getLeft() + childArea.getWidth() - (mainArea.getLeft() + mainArea.getWidth()));
            }
            case ALL: {
                return Math.max(Math.abs(childArea.getLeft() - mainArea.getLeft()), Math.abs(childArea.getWidth() - mainArea.getWidth()));
            }
        }
        return 0;
    }
}

