/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecRange;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Arrays;
import java.util.List;

public abstract class SpecValidationSize<T extends SpecRange>
extends SpecValidation<T> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        double realValue = this.getSizeValue(mainObject);
        double convertedValue = pageValidation.convertValue(((SpecRange)spec).getRange(), realValue);
        List<ValidationObject> validationObjects = Arrays.asList(new ValidationObject(mainObject.getArea(), objectName));
        if (!((SpecRange)spec).getRange().holds(convertedValue)) {
            throw new ValidationErrorException().withValidationObjects(validationObjects).withMessage(String.format("\"%s\" %s is %s", objectName, this.getUnitName(), this.getReadableRangeAndValue(((SpecRange)spec).getRange(), realValue, convertedValue, pageValidation)));
        }
        return new ValidationResult((Spec)spec, validationObjects);
    }

    protected abstract String getUnitName();

    protected abstract int getSizeValue(PageElement var1);
}

