/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Point;
import com.galenframework.page.Rect;
import com.galenframework.specs.Side;
import com.galenframework.specs.SpecInside;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import com.galenframework.validation.specs.SpecValidationGeneral;
import java.util.Arrays;
import java.util.List;

public class SpecValidationInside
extends SpecValidationGeneral<SpecInside> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecInside spec) throws ValidationErrorException {
        super.check(pageValidation, objectName, spec);
        PageElement mainObject = pageValidation.findPageElement(objectName);
        PageElement secondObject = pageValidation.findPageElement(spec.getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainArea, objectName), new ValidationObject(secondArea, spec.getObject()));
        if (!spec.getPartly()) {
            Point[] points = mainArea.getPoints();
            int maxOffset = 0;
            for (Point point : points) {
                int offset = secondArea.calculatePointOffsetDistance(point);
                if (maxOffset >= offset) continue;
                maxOffset = offset;
            }
            if (maxOffset > 2) {
                throw new ValidationErrorException().withValidationObjects(objects).withMessage(String.format("\"%s\" is not completely inside. The offset is %dpx.", objectName, maxOffset));
            }
        }
        return new ValidationResult(spec, objects);
    }

    @Override
    protected int getOffsetForSide(Rect mainArea, Rect parentArea, Side side, SpecInside spec) {
        if (side == Side.LEFT) {
            return mainArea.getLeft() - parentArea.getLeft();
        }
        if (side == Side.TOP) {
            return mainArea.getTop() - parentArea.getTop();
        }
        if (side == Side.RIGHT) {
            return parentArea.getLeft() + parentArea.getWidth() - (mainArea.getLeft() + mainArea.getWidth());
        }
        if (side == Side.BOTTOM) {
            return parentArea.getTop() + parentArea.getHeight() - (mainArea.getTop() + mainArea.getHeight());
        }
        return 0;
    }
}

