/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.Location;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.Side;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecComplex;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.LinkedList;
import java.util.List;

public abstract class SpecValidationGeneral<T extends SpecComplex>
extends SpecValidation<T> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement secondObject = pageValidation.findPageElement(((SpecComplex)spec).getObject());
        this.checkAvailability(secondObject, ((SpecComplex)spec).getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        LinkedList<String> messages = new LinkedList<String>();
        for (Location location : ((SpecComplex)spec).getLocations()) {
            String message = this.verifyLocation(mainArea, secondArea, location, pageValidation, spec);
            if (message == null) continue;
            messages.add(message);
        }
        LinkedList<ValidationObject> validationObjects = new LinkedList<ValidationObject>();
        validationObjects.add(new ValidationObject(mainArea, objectName));
        validationObjects.add(new ValidationObject(secondArea, ((SpecComplex)spec).getObject()));
        if (messages.size() > 0) {
            throw new ValidationErrorException().withMessage(this.createMessage(messages, objectName)).withValidationObjects(validationObjects);
        }
        return new ValidationResult((Spec)spec, (List<ValidationObject>)validationObjects);
    }

    private String createMessage(List<String> messages, String objectName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("\"%s\" ", objectName));
        boolean comma = false;
        for (String message : messages) {
            if (comma) {
                buffer.append(", ");
            }
            buffer.append("is ");
            buffer.append(message);
            comma = true;
        }
        return buffer.toString();
    }

    protected String verifyLocation(Rect mainArea, Rect secondArea, Location location, PageValidation pageValidation, T spec) {
        LinkedList<String> messages = new LinkedList<String>();
        Range range = location.getRange();
        for (Side side : location.getSides()) {
            int offset = this.getOffsetForSide(mainArea, secondArea, side, spec);
            double calculatedOffset = pageValidation.convertValue(range, offset);
            if (range.holds(calculatedOffset)) continue;
            if (range.isPercentage()) {
                int precision = range.findPrecision();
                messages.add(String.format("%s%% [%dpx] %s", new Object[]{new RangeValue(calculatedOffset, precision).toString(), offset, side}));
                continue;
            }
            messages.add(String.format("%dpx %s", new Object[]{offset, side}));
        }
        if (messages.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            boolean comma = false;
            for (String message : messages) {
                if (comma) {
                    buffer.append(" and ");
                }
                buffer.append(message);
                comma = true;
            }
            buffer.append(' ');
            buffer.append(range.getErrorMessageSuffix());
            if (range.isPercentage()) {
                int objectValue = pageValidation.getObjectValue(range.getPercentageOfValue());
                buffer.append(' ');
                buffer.append(this.rangeCalculatedFromPercentage(range, objectValue));
            }
            return buffer.toString();
        }
        return null;
    }

    protected abstract int getOffsetForSide(Rect var1, Rect var2, Side var3, T var4);
}

