/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.SpecDirectionPosition;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Arrays;
import java.util.List;

public class SpecValidationDirectionPosition
extends SpecValidation<SpecDirectionPosition> {
    private Direction direction;

    public SpecValidationDirectionPosition(Direction direction) {
        this.direction = direction;
    }

    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecDirectionPosition spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement secondObject = pageValidation.findPageElement(spec.getObject());
        this.checkAvailability(secondObject, spec.getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        int offset = this.getOffset(mainArea, secondArea);
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainArea, objectName), new ValidationObject(secondArea, spec.getObject()));
        double convertedOffset = pageValidation.convertValue(spec.getRange(), offset);
        if (!spec.getRange().holds(convertedOffset)) {
            throw new ValidationErrorException().withMessage(String.format("\"%s\" is %dpx %s \"%s\" %s", objectName, offset, this.direction.toString(), spec.getObject(), spec.getRange().getErrorMessageSuffix())).withValidationObjects(objects);
        }
        return new ValidationResult(spec, objects);
    }

    private int getOffset(Rect mainArea, Rect secondArea) {
        if (this.direction == Direction.ABOVE) {
            return secondArea.getTop() - mainArea.getTop() - mainArea.getHeight();
        }
        if (this.direction == Direction.BELOW) {
            return mainArea.getTop() - secondArea.getTop() - secondArea.getHeight();
        }
        if (this.direction == Direction.LEFT_OF) {
            return secondArea.getLeft() - mainArea.getLeft() - mainArea.getWidth();
        }
        if (this.direction == Direction.RIGHT_OF) {
            return mainArea.getLeft() - secondArea.getLeft() - secondArea.getWidth();
        }
        throw new SyntaxException("Unknown direction: " + this.direction.name());
    }

    public static enum Direction {
        ABOVE("above"),
        BELOW("below"),
        LEFT_OF("left of"),
        RIGHT_OF("right of");

        private final String reportingName;

        private Direction(String reportingName) {
            this.reportingName = reportingName;
        }

        public String toString() {
            return this.reportingName;
        }
    }
}

