/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.SpecCentered;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.util.Arrays;
import java.util.List;

public class SpecValidationCentered
extends SpecValidation<SpecCentered> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, SpecCentered spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement secondObject = pageValidation.findPageElement(spec.getObject());
        this.checkAvailability(secondObject, spec.getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        int offsetLeft = mainArea.getLeft() - secondArea.getLeft();
        int offsetRight = secondArea.getLeft() + secondArea.getWidth() - mainArea.getLeft() - mainArea.getWidth();
        int offsetTop = mainArea.getTop() - secondArea.getTop();
        int offsetBottom = secondArea.getTop() + secondArea.getHeight() - mainArea.getTop() - mainArea.getHeight();
        List<ValidationObject> objects = Arrays.asList(new ValidationObject(mainArea, objectName), new ValidationObject(secondArea, spec.getObject()));
        try {
            if (spec.getLocation() == SpecCentered.Location.INSIDE) {
                this.checkCentered(offsetLeft, offsetRight, offsetTop, offsetBottom, objectName, spec, "inside");
            } else {
                this.checkCentered(-offsetLeft, -offsetRight, -offsetTop, -offsetBottom, objectName, spec, "on");
            }
        }
        catch (ValidationErrorException exception) {
            exception.setValidationObjects(objects);
            throw exception;
        }
        return new ValidationResult(spec, objects);
    }

    private void checkCentered(int offsetLeft, int offsetRight, int offsetTop, int offsetBottom, String objectName, SpecCentered spec, String location) throws ValidationErrorException {
        if (spec.getAlignment() == SpecCentered.Alignment.HORIZONTALLY || spec.getAlignment() == SpecCentered.Alignment.ALL) {
            this.checkCentered(offsetLeft, offsetRight, objectName, spec, location, "horizontally");
        }
        if (spec.getAlignment() == SpecCentered.Alignment.VERTICALLY || spec.getAlignment() == SpecCentered.Alignment.ALL) {
            this.checkCentered(offsetTop, offsetBottom, objectName, spec, location, "vertically");
        }
    }

    private void checkCentered(int offsetA, int offsetB, String objectName, SpecCentered spec, String location, String alignment) throws ValidationErrorException {
        int offset = Math.abs(offsetA - offsetB);
        if (offset > spec.getErrorRate()) {
            throw new ValidationErrorException(String.format("\"%s\" is not centered %s %s \"%s\". Offset is %dpx", objectName, alignment, location, spec.getObject(), offset));
        }
        if (offsetA < 0 || offsetB < 0) {
            throw new ValidationErrorException(String.format("\"%s\" is centered but not %s %s \"%s\"", objectName, alignment, location, spec.getObject(), offset));
        }
    }
}

