/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.specs.Spec;
import com.galenframework.validation.ValidationError;
import com.galenframework.validation.ValidationObject;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ValidationResult {
    private Spec spec;
    private List<ValidationObject> validationObjects = new LinkedList<ValidationObject>();
    private ValidationError error;
    private List<ValidationResult> childValidationResults;

    public ValidationResult(Spec spec, List<ValidationObject> validationObjects) {
        this.spec = spec;
        this.validationObjects = validationObjects;
    }

    public ValidationResult(Spec spec) {
        this.spec = spec;
    }

    public ValidationResult(Spec spec, List<ValidationObject> validationObjects, ValidationError validationError) {
        this.spec = spec;
        this.validationObjects = validationObjects;
        this.error = validationError;
    }

    public List<ValidationObject> getValidationObjects() {
        return this.validationObjects;
    }

    public void setValidationObjects(List<ValidationObject> validationObjects) {
        this.validationObjects = validationObjects;
    }

    public ValidationError getError() {
        return this.error;
    }

    public void setError(ValidationError error) {
        this.error = error;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.validationObjects).append((Object)this.error).append(this.childValidationResults).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValidationResult)) {
            return false;
        }
        ValidationResult rhs = (ValidationResult)obj;
        return new EqualsBuilder().append((Object)this.error, (Object)rhs.error).append(this.validationObjects, rhs.validationObjects).append(this.childValidationResults, rhs.childValidationResults).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("objects", this.validationObjects).append("error", (Object)this.error).append("childValidationResults", this.childValidationResults).toString();
    }

    public List<ValidationResult> getChildValidationResults() {
        return this.childValidationResults;
    }

    public void setChildValidationResults(List<ValidationResult> childValidationResults) {
        this.childValidationResults = childValidationResults;
    }

    public ValidationResult withObjects(List<ValidationObject> objects) {
        this.setValidationObjects(objects);
        return this;
    }

    public ValidationResult withError(ValidationError error) {
        this.setError(error);
        return this;
    }

    public ValidationResult withChildValidationResults(List<ValidationResult> childValidationResults) {
        this.setChildValidationResults(childValidationResults);
        return this;
    }

    public Spec getSpec() {
        return this.spec;
    }
}

