/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.validation.ImageComparison;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ValidationError {
    private List<String> messages;
    private ImageComparison imageComparison;
    private boolean onlyWarn;

    public ValidationError(List<String> messages) {
        this.messages = messages;
    }

    public ValidationError(List<String> messages, ImageComparison imageComparison) {
        this.messages = messages;
        this.imageComparison = imageComparison;
    }

    public ValidationError() {
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.messages).append(this.onlyWarn).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError rhs = (ValidationError)obj;
        return new EqualsBuilder().append(this.messages, rhs.messages).append(this.onlyWarn, rhs.onlyWarn).isEquals();
    }

    public String toString() {
        return String.format("Error{%s, onlyWarn=%s}", this.messages, this.onlyWarn);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public ValidationError withMessage(String message) {
        if (this.messages == null) {
            this.messages = new LinkedList<String>();
        }
        this.messages.add(message);
        return this;
    }

    public void setOnlyWarn(boolean onlyWarn) {
        this.onlyWarn = onlyWarn;
    }

    public boolean isOnlyWarn() {
        return this.onlyWarn;
    }

    public ValidationError withOnlyWarn(boolean onlyWarn) {
        this.setOnlyWarn(onlyWarn);
        return this;
    }

    public ImageComparison getImageComparison() {
        return this.imageComparison;
    }

    public ValidationError withImageComparison(ImageComparison imageComparison) {
        this.imageComparison = imageComparison;
        return this;
    }
}

