/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.config.GalenConfig;
import com.galenframework.page.PageElement;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.PageSpec;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationResult;
import java.util.LinkedList;
import java.util.List;

public abstract class SpecValidation<T extends Spec> {
    protected static final String OBJECT_WITH_NAME_S_IS_NOT_DEFINED_IN_PAGE_SPEC = "Cannot find locator for \"%s\" in page spec";
    protected static final String OBJECT_S_IS_ABSENT_ON_PAGE = "\"%s\" is absent on page";
    protected static final String OBJECT_S_IS_NOT_VISIBLE_ON_PAGE = "\"%s\" is not visible on page";

    public abstract ValidationResult check(PageValidation var1, String var2, T var3) throws ValidationErrorException;

    protected void checkAvailability(PageElement object, String objectName) throws ValidationErrorException {
        if (GalenConfig.getConfig().shouldCheckVisibilityGlobally()) {
            if (object == null) {
                throw new ValidationErrorException(String.format(OBJECT_WITH_NAME_S_IS_NOT_DEFINED_IN_PAGE_SPEC, objectName));
            }
            if (!object.isPresent()) {
                throw new ValidationErrorException(String.format(OBJECT_S_IS_ABSENT_ON_PAGE, objectName));
            }
            if (!object.isVisible()) {
                throw new ValidationErrorException(String.format(OBJECT_S_IS_NOT_VISIBLE_ON_PAGE, objectName));
            }
        }
    }

    protected List<String> fetchChildObjets(List<String> childObjects, PageSpec pageSpec) throws ValidationErrorException {
        LinkedList<String> resultObjects = new LinkedList<String>();
        for (String objectName : childObjects) {
            if (objectName.contains("*")) {
                List<String> foundObjects = pageSpec.findOnlyExistingMatchingObjectNames(objectName);
                if (foundObjects.size() == 0) {
                    throw new ValidationErrorException("There are no objects matching: " + objectName);
                }
                resultObjects.addAll(foundObjects);
                continue;
            }
            resultObjects.add(objectName);
        }
        return resultObjects;
    }

    protected String getReadableRangeAndValue(Range range, double realValue, double convertedValue, PageValidation pageValidation) {
        if (range.isPercentage()) {
            int objectValue = pageValidation.getObjectValue(range.getPercentageOfValue());
            return String.format("%s%% [%dpx] %s %s", new RangeValue(convertedValue, range.findPrecision()).toString(), (int)realValue, range.getErrorMessageSuffix(), this.rangeCalculatedFromPercentage(range, objectValue));
        }
        return String.format("%spx %s", new RangeValue(realValue, range.findPrecision()).toString(), range.getErrorMessageSuffix());
    }

    protected String rangeCalculatedFromPercentage(Range range, int objectValue) {
        if (range.getRangeType() == Range.RangeType.BETWEEN) {
            int from = (int)((double)objectValue * range.getFrom().asDouble() / 100.0);
            int to = (int)((double)objectValue * range.getTo().asDouble() / 100.0);
            return String.format("[%d to %dpx]", from, to);
        }
        RangeValue rangeValue = SpecValidation.takeNonNullValue(range.getFrom(), range.getTo());
        int converted = (int)((double)objectValue * rangeValue.asDouble() / 100.0);
        return "[" + converted + "px]";
    }

    private static RangeValue takeNonNullValue(RangeValue from, RangeValue to) {
        if (from != null) {
            return from;
        }
        if (to != null) {
            return to;
        }
        throw new NullPointerException("Both range values are null");
    }
}

