/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation;

import com.galenframework.browser.Browser;
import com.galenframework.page.Page;
import com.galenframework.page.PageElement;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.Range;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.PageSpec;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationFactory;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationResult;
import java.lang.reflect.Method;

public class PageValidation {
    private Browser browser;
    private Page page;
    private PageSpec pageSpec;
    private ValidationListener validationListener;
    private SectionFilter sectionFilter;

    public PageValidation(Browser browser, Page page, PageSpec pageSpec, ValidationListener validationListener, SectionFilter sectionFilter) {
        this.setBrowser(browser);
        this.setPage(page);
        this.setPageSpec(pageSpec);
        this.setValidationListener(validationListener);
        this.setSectionFilter(sectionFilter);
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public ValidationResult check(String objectName, Spec spec) {
        SpecValidation<? extends Spec> specValidation = ValidationFactory.getValidation(spec, this);
        ValidationResult result = this.check(specValidation, objectName, spec);
        if (spec.isOnlyWarn() && result.getError() != null) {
            result.getError().setOnlyWarn(true);
        }
        return result;
    }

    private ValidationResult check(SpecValidation specValidation, String objectName, Spec spec) {
        try {
            return specValidation.check(this, objectName, spec);
        }
        catch (ValidationErrorException ex) {
            return ex.asValidationResult(spec);
        }
    }

    public PageSpec getPageSpec() {
        return this.pageSpec;
    }

    public void setPageSpec(PageSpec pageSpec) {
        this.pageSpec = pageSpec;
    }

    public PageElement findPageElement(String objectName) {
        Locator objectLocator = this.pageSpec.getObjectLocator(objectName);
        if (objectLocator != null) {
            return this.page.getObject(objectName, objectLocator);
        }
        return this.page.getSpecialObject(objectName);
    }

    private PageElement findPageElementOnPage(String objectName, Locator locator) {
        if (locator != null) {
            return this.page.getObject(objectName, locator);
        }
        return this.page.getSpecialObject(objectName);
    }

    private int convertToInt(Object objectValue) {
        if (objectValue == null) {
            throw new NullPointerException("The returned value is null");
        }
        if (objectValue instanceof Integer) {
            return (Integer)objectValue;
        }
        if (objectValue instanceof Double) {
            return ((Double)objectValue).intValue();
        }
        throw new SyntaxException(String.format("Cannot convert value to integer. The obtained value is of %s type", objectValue.getClass()));
    }

    private Object getObjectValue(Object object, String fieldPath) {
        int index = fieldPath.indexOf("/");
        if (index > 0 && index < fieldPath.length() - 1) {
            String fieldName = fieldPath.substring(0, index);
            String leftOverPath = fieldPath.substring(index + 1);
            if (leftOverPath.isEmpty()) {
                throw new SyntaxException(String.format("Cannot read path %s", fieldPath));
            }
            Object field = this.getField(object, fieldName);
            if (field == null) {
                throw new NullPointerException(String.format("\"%s\" returned null", fieldName));
            }
            return this.getObjectValue(field, leftOverPath);
        }
        return this.getField(object, fieldPath);
    }

    private Object getField(Object object, String fieldName) {
        try {
            Method getterMethod = object.getClass().getMethod(this.getterForField(fieldName), new Class[0]);
            return getterMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new SyntaxException(String.format("Cannot read field: \"%s\"", fieldName));
        }
    }

    private String getterForField(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public double convertValue(Range range, double realValue) {
        if (range.isPercentage()) {
            return this.calculatePrecentageOfRealValue(range.getPercentageOfValue(), realValue);
        }
        return realValue;
    }

    public int getObjectValue(String objectValuePath) {
        int index = objectValuePath.indexOf("/");
        if (index > 0 && index < objectValuePath.length() - 1) {
            String objectName = objectValuePath.substring(0, index);
            String fieldPath = objectValuePath.substring(index + 1);
            Locator locator = this.pageSpec.getObjectLocator(objectName);
            PageElement pageElement = this.findPageElementOnPage(objectName, locator);
            if (pageElement != null) {
                Object objectValue = this.getObjectValue(pageElement, fieldPath);
                return this.convertToInt(objectValue);
            }
            throw new SyntaxException(String.format("Locator for object \"%s\" is not specified", objectName));
        }
        throw new SyntaxException(String.format("Value path is incorrect %s", objectValuePath));
    }

    private double calculatePrecentageOfRealValue(String objectValuePath, double realValue) {
        int value = this.getObjectValue(objectValuePath);
        if (value != 0) {
            return realValue / (double)value * 100.0;
        }
        return 0.0;
    }

    public ValidationListener getValidationListener() {
        return this.validationListener;
    }

    public void setValidationListener(ValidationListener validationListener) {
        this.validationListener = validationListener;
    }

    public SectionFilter getSectionFilter() {
        return this.sectionFilter;
    }

    public void setSectionFilter(SectionFilter sectionFilter) {
        this.sectionFilter = sectionFilter;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }
}

