/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.utils;

import com.galenframework.browser.SeleniumBrowser;
import com.galenframework.browser.SeleniumBrowserFactory;
import com.galenframework.browser.SeleniumGridBrowserFactory;
import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.page.selenium.ByChain;
import com.galenframework.rainbow4j.Rainbow4J;
import com.galenframework.reports.TestReport;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.reports.nodes.LayoutReportNode;
import com.galenframework.reports.nodes.TestReportNode;
import com.galenframework.specs.page.Locator;
import com.galenframework.tests.GalenProperties;
import com.galenframework.tests.TestSession;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalenUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GalenUtils.class);
    private static final String URL_REGEX = "[a-zA-Z0-9]+://.*";
    public static final String JS_RETRIEVE_DEVICE_PIXEL_RATIO = "window.devicePixelRatio = window.devicePixelRatio || window.screen.deviceXDPI / window.screen.logicalXDPI; var pr = window.devicePixelRatio; if (pr != undefined && pr != null) return pr; else return 1.0;";
    public static final int ZERO_WIDTH_SPACE_CHAR = 65279;

    public static boolean isUrl(String url) {
        if (url == null) {
            return false;
        }
        return url.matches(URL_REGEX) || url.equals("-");
    }

    public static String formatScreenSize(Dimension screenSize) {
        if (screenSize != null) {
            return String.format("%dx%d", screenSize.width, screenSize.height);
        }
        return "0x0";
    }

    public static Dimension readSize(String sizeText) {
        if (sizeText == null) {
            return null;
        }
        if (!sizeText.matches("[0-9]+x[0-9]+")) {
            throw new RuntimeException("Incorrect screen size: " + sizeText);
        }
        String[] arr = sizeText.split("x");
        return new Dimension(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]));
    }

    public static File findFile(String specFile) {
        URL resource = GalenUtils.class.getResource(specFile);
        if (resource != null) {
            return new File(resource.getFile());
        }
        return new File(specFile);
    }

    public static File makeFullScreenshot(WebDriver driver) throws IOException, InterruptedException {
        BufferedImage resultingImage;
        GalenUtils.scrollVerticallyTo(driver, 0);
        byte[] bytes = (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(bytes));
        int capturedWidth = image.getWidth();
        int capturedHeight = image.getHeight();
        long longScrollHeight = ((Number)((JavascriptExecutor)driver).executeScript("return Math.max(document.body.scrollHeight, document.documentElement.scrollHeight,document.body.offsetHeight, document.documentElement.offsetHeight,document.body.clientHeight, document.documentElement.clientHeight);", new Object[0])).longValue();
        Double devicePixelRatio = ((Number)((JavascriptExecutor)driver).executeScript(JS_RETRIEVE_DEVICE_PIXEL_RATIO, new Object[0])).doubleValue();
        int scrollHeight = (int)longScrollHeight;
        File file = File.createTempFile("screenshot", ".png");
        int adaptedCapturedHeight = (int)((double)capturedHeight / devicePixelRatio);
        if (Math.abs(adaptedCapturedHeight - scrollHeight) > 40) {
            int scrollOffset = adaptedCapturedHeight;
            int times = scrollHeight / adaptedCapturedHeight;
            int leftover = scrollHeight % adaptedCapturedHeight;
            BufferedImage tiledImage = new BufferedImage(capturedWidth, (int)((double)scrollHeight * devicePixelRatio), 1);
            Graphics2D g2dTile = tiledImage.createGraphics();
            g2dTile.drawImage((Image)image, 0, 0, null);
            int scroll = 0;
            for (int i = 0; i < times - 1; ++i) {
                GalenUtils.scrollVerticallyTo(driver, scroll += scrollOffset);
                BufferedImage nextImage = ImageIO.read(new ByteArrayInputStream((byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES)));
                g2dTile.drawImage((Image)nextImage, 0, (i + 1) * capturedHeight, null);
            }
            if (leftover > 0) {
                GalenUtils.scrollVerticallyTo(driver, scroll += scrollOffset);
                BufferedImage nextImage = ImageIO.read(new ByteArrayInputStream((byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES)));
                BufferedImage lastPart = nextImage.getSubimage(0, nextImage.getHeight() - (int)((double)leftover * devicePixelRatio), nextImage.getWidth(), leftover);
                g2dTile.drawImage((Image)lastPart, 0, times * capturedHeight, null);
            }
            GalenUtils.scrollVerticallyTo(driver, 0);
            resultingImage = tiledImage;
        } else {
            resultingImage = image;
        }
        if (GalenConfig.getConfig().shouldAutoresizeScreenshots()) {
            try {
                resultingImage = GalenUtils.resizeScreenshotIfNeeded(driver, resultingImage);
            }
            catch (Exception ex) {
                LOG.trace("Couldn't resize screenshot", (Throwable)ex);
            }
        }
        ImageIO.write((RenderedImage)resultingImage, "png", file);
        return file;
    }

    public static BufferedImage resizeScreenshotIfNeeded(WebDriver driver, BufferedImage screenshotImage) {
        Double devicePixelRatio = 1.0;
        try {
            devicePixelRatio = ((Number)((JavascriptExecutor)driver).executeScript(JS_RETRIEVE_DEVICE_PIXEL_RATIO, new Object[0])).doubleValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (devicePixelRatio > 1.0 && screenshotImage.getWidth() > 0) {
            Long screenSize = ((Number)((JavascriptExecutor)driver).executeScript("return Math.max(document.body.scrollWidth, document.documentElement.scrollWidth,document.body.offsetWidth, document.documentElement.offsetWidth,document.body.clientWidth, document.documentElement.clientWidth);", new Object[0])).longValue();
            Double estimatedPixelRatio = (double)screenshotImage.getWidth() / (double)screenSize.longValue();
            if (estimatedPixelRatio > 1.0) {
                int newWidth = (int)((double)screenshotImage.getWidth() / estimatedPixelRatio);
                int newHeight = (int)((double)screenshotImage.getHeight() / estimatedPixelRatio);
                Image tmp = screenshotImage.getScaledInstance(newWidth, newHeight, 4);
                BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 1);
                Graphics2D g2d = scaledImage.createGraphics();
                g2d.drawImage(tmp, 0, 0, null);
                g2d.dispose();
                return scaledImage;
            }
            return screenshotImage;
        }
        return screenshotImage;
    }

    public static void scrollVerticallyTo(WebDriver driver, int scroll) {
        ((JavascriptExecutor)driver).executeScript("window.scrollTo(0, " + scroll + ");", new Object[0]);
        try {
            GalenUtils.waitUntilItIsScrolledToPosition(driver, scroll);
        }
        catch (InterruptedException e) {
            LOG.trace("Interrupt error during scrolling occurred.", (Throwable)e);
        }
    }

    private static void waitUntilItIsScrolledToPosition(WebDriver driver, int scrollPosition) throws InterruptedException {
        int hardTime = GalenConfig.getConfig().getIntProperty(GalenProperty.SCREENSHOT_FULLPAGE_SCROLLWAIT);
        if (hardTime > 0) {
            Thread.sleep(hardTime);
        }
        boolean isScrolledToPosition = false;
        for (int time = GalenConfig.getConfig().getIntProperty(GalenProperty.SCREENSHOT_FULLPAGE_SCROLLTIMEOUT).intValue(); time >= 0 && !isScrolledToPosition; time -= 50) {
            Thread.sleep(50L);
            isScrolledToPosition = Math.abs(GalenUtils.obtainVerticalScrollPosition(driver) - scrollPosition) < 3;
        }
    }

    private static int obtainVerticalScrollPosition(WebDriver driver) {
        Number scrollLong = (Number)((JavascriptExecutor)driver).executeScript("return (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;", new Object[0]);
        return scrollLong.intValue();
    }

    public static String convertToFileName(String name) {
        return name.toLowerCase().replaceAll("[^\\dA-Za-z\\.\\-]", " ").replaceAll("\\s+", "-");
    }

    public static WebDriver createDriver(String browserType, String url, String size) {
        if (browserType == null) {
            browserType = GalenConfig.getConfig().getDefaultBrowser();
        }
        SeleniumBrowser browser = (SeleniumBrowser)new SeleniumBrowserFactory(browserType).openBrowser();
        if (url != null && !url.trim().isEmpty()) {
            browser.load(url);
        }
        if (size != null && !size.trim().isEmpty()) {
            browser.changeWindowSize(GalenUtils.readSize(size));
        }
        return browser.getDriver();
    }

    public static WebDriver createGridDriver(String gridUrl, String browserName, String browserVersion, String platform, Map<String, String> desiredCapabilities, String size) {
        SeleniumGridBrowserFactory factory = new SeleniumGridBrowserFactory(gridUrl);
        factory.setBrowser(browserName);
        factory.setBrowserVersion(browserVersion);
        if (platform != null) {
            factory.setPlatform(Platform.valueOf((String)platform));
        }
        if (desiredCapabilities != null) {
            factory.setDesiredCapabilites(desiredCapabilities);
        }
        WebDriver driver = ((SeleniumBrowser)factory.openBrowser()).getDriver();
        GalenUtils.resizeDriver(driver, size);
        return driver;
    }

    public static void resizeDriver(WebDriver driver, String sizeText) {
        if (sizeText != null && !sizeText.trim().isEmpty()) {
            Dimension size = GalenUtils.readSize(sizeText);
            GalenUtils.resizeDriver(driver, size.width, size.height);
        }
    }

    public static void resizeDriver(WebDriver driver, int width, int height) {
        if (GalenConfig.getConfig().getBooleanProperty(GalenProperty.GALEN_BROWSER_VIEWPORT_ADJUSTSIZE)) {
            GalenUtils.autoAdjustBrowserWindowSizeToFitViewport(driver, width, height);
        } else {
            driver.manage().window().setSize(new org.openqa.selenium.Dimension(width, height));
        }
    }

    public static File takeScreenshot(WebDriver driver) throws IOException {
        File file = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
        if (GalenConfig.getConfig().shouldAutoresizeScreenshots()) {
            BufferedImage image = Rainbow4J.loadImage((String)file.getAbsolutePath());
            File newFile = File.createTempFile("screenshot", ".png");
            image = GalenUtils.resizeScreenshotIfNeeded(driver, image);
            Rainbow4J.saveImage((BufferedImage)image, (File)newFile);
            return newFile;
        }
        return file;
    }

    public static Properties loadProperties(String fileName) throws IOException {
        GalenProperties properties = null;
        properties = TestSession.current() != null ? TestSession.current().getProperties() : new GalenProperties();
        properties.load(new File(fileName));
        return properties.getProperties();
    }

    public static void cookie(WebDriver driver, String cookie) {
        String script = "document.cookie=\"" + StringEscapeUtils.escapeJava((String)cookie) + "\";";
        GalenUtils.injectJavascript(driver, script);
    }

    public static Object injectJavascript(WebDriver driver, String script) {
        return ((JavascriptExecutor)driver).executeScript(script, new Object[0]);
    }

    public static Object[] listToArray(List<?> list) {
        if (list == null) {
            return new Object[0];
        }
        Object[] arr = new Object[list.size()];
        return list.toArray(arr);
    }

    public static String getParentForFile(String filePath) {
        if (filePath != null) {
            return new File(filePath).getParent();
        }
        return null;
    }

    public static InputStream findFileOrResourceAsStream(String filePath) {
        InputStream stream;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        if ((stream = GalenUtils.class.getResourceAsStream(filePath)) != null) {
            return stream;
        }
        String windowsFilePath = filePath.replace("\\", "/");
        return GalenUtils.class.getResourceAsStream(windowsFilePath);
    }

    public static String calculateFileId(String fullPath) {
        InputStream is = GalenUtils.findFileOrResourceAsStream(fullPath);
        return GalenUtils.calculateFileId(fullPath, is);
    }

    public static String calculateFileId(String fullPath, InputStream inputStream) {
        try {
            String fileName = new File(fullPath).getName();
            MessageDigest md = MessageDigest.getInstance("MD5");
            new DigestInputStream(inputStream, md);
            byte[] hashBytes = md.digest();
            return fileName + GalenUtils.convertHashBytesToString(hashBytes);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not calculate file id", ex);
        }
    }

    private static String convertHashBytesToString(byte[] hashBytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : hashBytes) {
            builder.append(Integer.toHexString(0xFF & b));
        }
        return builder.toString();
    }

    public static Pattern convertObjectNameRegex(String regex) {
        String jRegex = regex.replace("#", "[0-9]+").replace("*", ".*");
        return Pattern.compile(jRegex);
    }

    public static boolean isObjectsSearchExpression(String singleExpression) {
        if (singleExpression.startsWith("&")) {
            return true;
        }
        for (int i = 0; i < singleExpression.length(); ++i) {
            char symbol = singleExpression.charAt(i);
            if (symbol != '*' && symbol != '#') continue;
            return true;
        }
        return false;
    }

    public static String toCommaSeparated(List<String> list) {
        if (list != null) {
            StringBuffer buff = new StringBuffer();
            boolean comma = false;
            for (String item : list) {
                if (comma) {
                    buff.append(',');
                }
                comma = true;
                buff.append(item);
            }
            return buff.toString();
        }
        return "";
    }

    public static String removeNonPrintableControlSymbols(String line) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if ((ch < ' ' || ch >= '\ufeff') && ch != '\t') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static Dimension getViewportArea(WebDriver driver) {
        List size = (List)((JavascriptExecutor)driver).executeScript("return [document.documentElement.clientWidth|| document.body.clientWidth|| window.innerWidth,document.documentElement.clientHeight|| document.body.clientHeight|| window.innerHeight];", new Object[0]);
        return new Dimension(((Number)size.get(0)).intValue(), ((Number)size.get(1)).intValue());
    }

    public static void autoAdjustBrowserWindowSizeToFitViewport(WebDriver driver, int width, int height) {
        driver.manage().window().setSize(new org.openqa.selenium.Dimension(width, height));
        Dimension viewport = GalenUtils.getViewportArea(driver);
        if (viewport.getWidth() < (double)width) {
            int delta = (int)((double)width - viewport.getWidth());
            driver.manage().window().setSize(new org.openqa.selenium.Dimension(width + delta, height));
        }
    }

    public static List<String> fromCommaSeparated(String parameters) {
        String[] paramArray;
        LinkedList<String> items = new LinkedList<String>();
        for (String param : paramArray = parameters.split(",")) {
            String trimmed = param.trim();
            if (trimmed.isEmpty()) continue;
            items.add(trimmed);
        }
        return items;
    }

    public static boolean isObjectGroup(String singleExpression) {
        return singleExpression.startsWith("&");
    }

    public static String extractGroupName(String singleExpression) {
        return singleExpression.substring(1);
    }

    public static InputStream findMandatoryFileOrResourceAsStream(String imagePath) throws FileNotFoundException {
        InputStream stream = GalenUtils.findFileOrResourceAsStream(imagePath);
        if (stream == null) {
            throw new FileNotFoundException(imagePath);
        }
        return stream;
    }

    public static WebElement findWebElement(WebDriver driver, Locator locator) {
        return ByChain.fromLocator(locator).findElement((SearchContext)driver);
    }

    public static List<WebElement> findWebElements(WebDriver driver, Locator locator) {
        return ByChain.fromLocator(locator).findElements((SearchContext)driver);
    }

    public static void attachLayoutReport(LayoutReport layoutReport, TestReport report, String fileName, List<String> includedTagsList) {
        if (report != null) {
            String reportTitle = "Check layout: " + fileName + " included tags: " + GalenUtils.toCommaSeparated(includedTagsList);
            LayoutReportNode layoutReportNode = new LayoutReportNode(report.getFileStorage(), layoutReport, reportTitle);
            if (layoutReport.errors() > 0) {
                layoutReportNode.setStatus(TestReportNode.Status.ERROR);
            }
            report.addNode(layoutReportNode);
        }
    }

    public static List<String> findFilesOrResourcesMatchingSearchExpression(String imagePossiblePath) {
        LinkedList<String> foundFilePaths;
        block7: {
            block6: {
                String[] candidateNames;
                String slash = File.separator;
                int lastSlashPosition = imagePossiblePath.lastIndexOf(slash);
                if (lastSlashPosition < 0 && (lastSlashPosition = imagePossiblePath.lastIndexOf("/")) >= 0) {
                    slash = "/";
                }
                foundFilePaths = new LinkedList<String>();
                if (lastSlashPosition <= 0) break block6;
                String dirPath = imagePossiblePath.substring(0, lastSlashPosition);
                String namePatternText = imagePossiblePath.substring(lastSlashPosition + 1);
                Pattern namePattern = GalenUtils.convertObjectNameRegex(namePatternText);
                File dir = new File(dirPath);
                if (!dir.exists()) {
                    dir = new File(GalenUtils.class.getResource(dirPath).getFile());
                }
                if (!dir.exists()) break block7;
                for (String candidateName : candidateNames = dir.list()) {
                    if (!namePattern.matcher(candidateName).matches()) continue;
                    foundFilePaths.add(dirPath + slash + candidateName);
                }
                break block7;
            }
            File dir = new File(".");
            if (!dir.exists()) {
                dir = new File(GalenUtils.class.getResource(".").getFile());
            }
            if (dir.exists()) {
                String[] candidateNames;
                Pattern namePattern = GalenUtils.convertObjectNameRegex(imagePossiblePath);
                for (String candidateName : candidateNames = dir.list()) {
                    if (!namePattern.matcher(candidateName).matches()) continue;
                    foundFilePaths.add(candidateName);
                }
            }
        }
        return foundFilePaths;
    }

    public static void makeSureFolderExists(String reportFolderPath) throws IOException {
        File newDirectory = new File(reportFolderPath);
        GalenUtils.makeSureFolderExists(newDirectory);
    }

    public static void makeSureFolderExists(File dir) throws IOException {
        FileUtils.forceMkdir((File)dir);
        if (!FileUtils.waitFor((File)dir, (int)GalenConfig.getConfig().getIntProperty(GalenProperty.FILE_CREATE_TIMEOUT))) {
            throw new IOException(String.format("Couldn't create folder: %s", dir.getAbsolutePath()));
        }
    }
}

