/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.Node;
import com.galenframework.suite.reader.Table;
import com.galenframework.suite.reader.TableRowNode;
import com.galenframework.suite.reader.TestNode;
import com.galenframework.tests.GalenBasicTest;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ParameterizedNode
extends Node<List<GalenBasicTest>> {
    private Node<?> toParameterize;
    private boolean disabled = false;
    private List<String> groups;

    public ParameterizedNode(String text, Place place) {
        super(text, place);
    }

    @Override
    public List<GalenBasicTest> build(VarsContext context) {
        Table table = this.createTable(context);
        VarsContext parameterizedContext = new VarsContext(new Properties(), context);
        LinkedList<GalenBasicTest> tests = new LinkedList<GalenBasicTest>();
        table.forEach(values -> {
            parameterizedContext.addValuesFromMap(values);
            if (this.toParameterize instanceof ParameterizedNode) {
                ParameterizedNode parameterizedNode = (ParameterizedNode)this.toParameterize;
                tests.addAll(this.wrapTestsWithGroups((List<GalenBasicTest>)parameterizedNode.build(parameterizedContext), this.groups));
            } else if (this.toParameterize instanceof TestNode) {
                TestNode suiteNode = (TestNode)this.toParameterize;
                tests.add(this.wrapTestWithGroups(suiteNode.build(parameterizedContext), this.groups));
            }
        });
        return tests;
    }

    private List<GalenBasicTest> wrapTestsWithGroups(List<GalenBasicTest> tests, List<String> groups) {
        if (groups != null) {
            for (GalenBasicTest test : tests) {
                this.wrapTestWithGroups(test, groups);
            }
        }
        return tests;
    }

    private GalenBasicTest wrapTestWithGroups(GalenBasicTest test, List<String> groups) {
        if (groups != null) {
            if (test.getGroups() != null) {
                test.getGroups().addAll(groups);
            } else {
                test.setGroups(groups);
            }
        }
        return test;
    }

    private Table createTable(VarsContext context) {
        String line = this.getArguments().trim();
        Table tableFromChild = this.buildFromChild(context);
        Table table = null;
        if (!line.isEmpty()) {
            String[] tableNames;
            int indexOfFirstSpace = line.indexOf(32);
            if (indexOfFirstSpace < 0) {
                throw new SyntaxException(this.getPlace(), "Incorrect syntax.");
            }
            String firstWord = line.substring(0, indexOfFirstSpace).toLowerCase();
            if (!firstWord.equals("using")) {
                throw new SyntaxException(this.getPlace(), "Unknown statement: " + firstWord);
            }
            String leftover = line.substring(indexOfFirstSpace);
            for (String tableName : tableNames = leftover.split(",")) {
                String trimmedTableName = tableName.trim();
                if (trimmedTableName.isEmpty()) continue;
                Table contextTable = (Table)context.getValue(trimmedTableName);
                if (contextTable == null) {
                    throw new SyntaxException(this.getPlace(), String.format("Table with name \"%s\" does not exist", trimmedTableName));
                }
                if (table == null) {
                    table = contextTable;
                    continue;
                }
                try {
                    table.mergeWith(contextTable);
                }
                catch (Exception ex) {
                    throw new SyntaxException(this.getPlace(), String.format("Cannot merge table \"%s\". Perhaps it has different amount of columns", trimmedTableName));
                }
            }
            try {
                table.mergeWith(tableFromChild);
            }
            catch (Exception ex) {
                throw new SyntaxException(this.getPlace(), String.format("Cannot merge in-built table. It probably has different amount of columns then in \"%s\"", line));
            }
        } else {
            table = tableFromChild;
        }
        return table;
    }

    private Table buildFromChild(VarsContext context) {
        Table table = new Table();
        for (Node<?> childNode : this.getChildNodes()) {
            if (!(childNode instanceof TableRowNode)) continue;
            TableRowNode row = (TableRowNode)childNode;
            table.addRow((List<String>)row.build(context), row.getPlace());
        }
        return table;
    }

    @Override
    public Node<?> processNewNode(String text, Place place) {
        this.add(new TableRowNode(text, place));
        return this;
    }

    public void setToParameterize(Node<?> node) {
        this.toParameterize = node;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getGroups() {
        return this.groups;
    }
}

