/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.reader;

import com.galenframework.parser.SyntaxException;
import com.galenframework.parser.VarsContext;
import com.galenframework.specs.Place;
import com.galenframework.suite.reader.Node;
import com.galenframework.suite.reader.ParameterizedNode;
import com.galenframework.suite.reader.RootNode;
import com.galenframework.suite.reader.SetNode;
import com.galenframework.suite.reader.SuiteReaderException;
import com.galenframework.suite.reader.TableNode;
import com.galenframework.suite.reader.TestNode;
import com.galenframework.tests.GalenBasicTest;
import com.galenframework.utils.GalenUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class GalenSuiteLineProcessor {
    private RootNode rootNode;
    private Node<?> currentNode;
    private boolean disableNextSuite;
    private String contextPath;
    private Properties properties;
    private List<String> groupsForNextTest;

    public GalenSuiteLineProcessor(Properties properties, String contextPath) {
        this.currentNode = this.rootNode = new RootNode();
        this.disableNextSuite = false;
        this.contextPath = contextPath;
        this.properties = properties;
    }

    public void processLine(String text, Place place) throws IOException {
        if (!(this.isBlank(text) || this.isCommented(text) || this.isSeparator(text))) {
            if (text.startsWith("@@")) {
                Node<?> node = this.processSpecialInstruction(text.substring(2).trim(), place);
                if (node != null) {
                    this.currentNode = node;
                }
            } else {
                int spaces = GalenSuiteLineProcessor.calculateIndentationSpaces(text);
                Node<?> processingNode = this.currentNode.findProcessingNodeByIndentation(spaces);
                Node<?> newNode = processingNode.processNewNode(text, place);
                if (newNode instanceof TestNode) {
                    if (this.disableNextSuite) {
                        this.disableNextSuite = false;
                        ((TestNode)newNode).setDisabled(true);
                    }
                    if (this.groupsForNextTest != null) {
                        ((TestNode)newNode).setGroups(this.groupsForNextTest);
                        this.groupsForNextTest = null;
                    }
                }
                this.currentNode = newNode;
            }
        }
    }

    private Node<?> processSpecialInstruction(String text, Place place) throws IOException {
        String leftover;
        String firstWord;
        this.currentNode = this.rootNode;
        int indexOfFirstSpace = text.indexOf(32);
        if (indexOfFirstSpace > 0) {
            firstWord = text.substring(0, indexOfFirstSpace).toLowerCase();
            leftover = text.substring(indexOfFirstSpace).trim();
        } else {
            firstWord = text.toLowerCase();
            leftover = "";
        }
        if (firstWord.equals("set")) {
            return this.processInstructionSet(leftover, place);
        }
        if (firstWord.equals("table")) {
            return this.processTable(leftover, place);
        }
        if (firstWord.equals("parameterized")) {
            return this.processParameterized(leftover, place);
        }
        if (firstWord.equals("disabled")) {
            this.markNextSuiteAsDisabled();
            return null;
        }
        if (firstWord.equals("groups")) {
            this.markNextSuiteGroupedWith(leftover);
            return null;
        }
        if (firstWord.equals("import")) {
            List<Node<?>> nodes = this.importSuite(leftover, place);
            this.rootNode.getChildNodes().addAll(nodes);
            return null;
        }
        throw new SuiteReaderException("Unknown instruction: " + firstWord);
    }

    private List<Node<?>> importSuite(String path, Place place) throws IOException {
        if (path.isEmpty()) {
            throw new SyntaxException(place, "No path specified for importing");
        }
        String fullChildPath = this.contextPath + File.separator + path;
        String childContextPath = new File(fullChildPath).getParent();
        GalenSuiteLineProcessor childProcessor = new GalenSuiteLineProcessor(this.properties, childContextPath);
        File file = new File(fullChildPath);
        if (!file.exists()) {
            throw new SyntaxException(place, "File doesn't exist: " + file.getAbsolutePath());
        }
        childProcessor.readLines(new FileInputStream(file), fullChildPath);
        return childProcessor.rootNode.getChildNodes();
    }

    private void markNextSuiteGroupedWith(String commaSeparatedGroups) {
        String[] groupsArray = commaSeparatedGroups.split(",");
        LinkedList<String> groups = new LinkedList<String>();
        for (String group : groupsArray) {
            String trimmedGroup = group.trim();
            if (trimmedGroup.isEmpty()) continue;
            groups.add(trimmedGroup);
        }
        this.groupsForNextTest = groups;
    }

    private void markNextSuiteAsDisabled() {
        this.disableNextSuite = true;
    }

    private Node<?> processParameterized(String text, Place place) {
        ParameterizedNode parameterizedNode = new ParameterizedNode(text, place);
        if (this.disableNextSuite) {
            parameterizedNode.setDisabled(true);
            this.disableNextSuite = false;
        }
        if (this.groupsForNextTest != null) {
            parameterizedNode.setGroups(this.groupsForNextTest);
            this.groupsForNextTest = null;
        }
        this.currentNode.add(parameterizedNode);
        return parameterizedNode;
    }

    private Node<?> processTable(String text, Place place) {
        TableNode tableNode = new TableNode(text, place);
        this.currentNode.add(tableNode);
        return tableNode;
    }

    private Node<?> processInstructionSet(String text, Place place) {
        SetNode newNode = new SetNode(text, place);
        this.currentNode.add(newNode);
        return newNode;
    }

    public List<GalenBasicTest> buildSuites() {
        return this.rootNode.build(new VarsContext(this.properties));
    }

    public static int calculateIndentationSpaces(String text) {
        int spacesCount = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ') {
                ++spacesCount;
                continue;
            }
            if (text.charAt(i) == '\t') {
                spacesCount += 4;
                continue;
            }
            return spacesCount;
        }
        return 0;
    }

    private boolean isSeparator(String text) {
        if ((text = text.trim()).length() > 3) {
            char ch = text.charAt(0);
            for (int i = 1; i < text.length(); ++i) {
                if (ch == text.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isBlank(String text) {
        return text.trim().isEmpty();
    }

    private boolean isCommented(String text) {
        return text.trim().startsWith("#");
    }

    public void readLines(InputStream inputStream, String sourceName) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String lineText = bufferedReader.readLine();
        int lineNumber = 0;
        while (lineText != null) {
            lineText = GalenUtils.removeNonPrintableControlSymbols(lineText);
            this.processLine(lineText, new Place(sourceName, ++lineNumber));
            lineText = bufferedReader.readLine();
        }
    }
}

