/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions;

import com.galenframework.browser.Browser;
import com.galenframework.browser.SeleniumBrowser;
import com.galenframework.javascript.GalenJsExecutor;
import com.galenframework.reports.TestReport;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.utils.GalenUtils;
import com.galenframework.validation.ValidationListener;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openqa.selenium.WebDriver;

public class GalenPageActionRunJavascript
extends GalenPageAction {
    private String javascriptPath;
    private String jsonArguments;

    public GalenPageActionRunJavascript(String javascriptPath) {
        this.setJavascriptPath(javascriptPath);
    }

    @Override
    public void execute(TestReport report, Browser browser, GalenPageTest pageTest, ValidationListener validationListener) throws Exception {
        File file = GalenUtils.findFile(this.javascriptPath);
        FileReader scriptFileReader = new FileReader(file);
        GalenJsExecutor js = new GalenJsExecutor();
        js.eval(GalenJsExecutor.loadJsFromLibrary("GalenPages.js"));
        js.putObject("browser", browser);
        this.provideWebDriverInstance(js, browser);
        js.eval("var arg = " + this.jsonArguments);
        js.eval(scriptFileReader, this.javascriptPath);
    }

    private void provideWebDriverInstance(GalenJsExecutor jsExecutor, Browser browser) {
        if (browser instanceof SeleniumBrowser) {
            SeleniumBrowser seleniumBrowser = (SeleniumBrowser)browser;
            WebDriver driver = seleniumBrowser.getDriver();
            jsExecutor.putObject("driver", driver);
        }
    }

    public String getJavascriptPath() {
        return this.javascriptPath;
    }

    public void setJavascriptPath(String javascriptPath) {
        this.javascriptPath = javascriptPath;
    }

    public GalenPageAction withArguments(String jsonArguments) {
        this.setJsonArguments(jsonArguments);
        return this;
    }

    public String getJsonArguments() {
        return this.jsonArguments;
    }

    public void setJsonArguments(String jsonArguments) {
        this.jsonArguments = jsonArguments;
    }

    public GalenPageActionRunJavascript withJsonArguments(String jsonArguments) {
        this.setJsonArguments(jsonArguments);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.javascriptPath).append((Object)this.jsonArguments).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenPageActionRunJavascript)) {
            return false;
        }
        GalenPageActionRunJavascript rhs = (GalenPageActionRunJavascript)obj;
        return new EqualsBuilder().append((Object)this.javascriptPath, (Object)rhs.javascriptPath).append((Object)this.jsonArguments, (Object)rhs.jsonArguments).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("javascriptPath", (Object)this.javascriptPath).append("jsonArguments", (Object)this.jsonArguments).toString();
    }
}

