/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions;

import com.galenframework.browser.Browser;
import com.galenframework.reports.TestReport;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.validation.ValidationListener;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenPageActionCookie
extends GalenPageAction {
    private List<String> cookies;

    @Override
    public void execute(TestReport report, Browser browser, GalenPageTest pageTest, ValidationListener validationListener) throws Exception {
        if (this.cookies != null && this.cookies.size() > 0) {
            StringBuilder js = new StringBuilder();
            for (String cookie : this.cookies) {
                js.append("document.cookie=\"" + StringEscapeUtils.escapeJava((String)cookie) + "\";");
            }
            browser.executeJavascript(js.toString());
            browser.refresh();
        }
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<String> cookies) {
        this.cookies = cookies;
    }

    public GalenPageActionCookie withCookies(String ... cookieArray) {
        this.cookies = Arrays.asList(cookieArray);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.cookies).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenPageActionCookie)) {
            return false;
        }
        GalenPageActionCookie rhs = (GalenPageActionCookie)obj;
        return new EqualsBuilder().append(this.cookies, rhs.cookies).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cookies", this.cookies).toString();
    }
}

