/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.suite.actions;

import com.galenframework.api.Galen;
import com.galenframework.browser.Browser;
import com.galenframework.reports.TestReport;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.utils.GalenUtils;
import com.galenframework.validation.ValidationListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenPageActionCheck
extends GalenPageAction {
    private static final File NO_SCREENSHOT = null;
    private String specPath;
    private List<String> includedTags;
    private List<String> excludedTags;
    private Map<String, Object> jsVariables;

    @Override
    public void execute(TestReport report, Browser browser, GalenPageTest pageTest, ValidationListener validationListener) throws IOException {
        SectionFilter sectionFilter = new SectionFilter(this.getIncludedTags(), this.getExcludedTags());
        LayoutReport layoutReport = Galen.checkLayout(browser, this.specPath, sectionFilter, this.getCurrentProperties(), this.jsVariables, NO_SCREENSHOT, validationListener);
        GalenUtils.attachLayoutReport(layoutReport, report, this.specPath, this.includedTags);
    }

    public GalenPageActionCheck withSpec(String specPath) {
        this.setSpecPath(specPath);
        return this;
    }

    public GalenPageActionCheck withIncludedTags(List<String> includedTags) {
        this.setIncludedTags(includedTags);
        return this;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public void setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
    }

    public GalenPageActionCheck withExcludedTags(List<String> excludedTags) {
        this.setExcludedTags(excludedTags);
        return this;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public void setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.specPath).append(this.includedTags).append(this.excludedTags).append(this.jsVariables).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenPageActionCheck)) {
            return false;
        }
        GalenPageActionCheck rhs = (GalenPageActionCheck)obj;
        return new EqualsBuilder().append((Object)this.specPath, (Object)rhs.specPath).append(this.includedTags, rhs.includedTags).append(this.excludedTags, rhs.excludedTags).append(this.jsVariables, rhs.jsVariables).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("specPath", (Object)this.specPath).append("includedTags", this.includedTags).append("excludedTags", this.excludedTags).append("jsVariables", this.jsVariables).toString();
    }

    public void setSpecPath(String specPath) {
        this.specPath = specPath;
    }

    public GalenPageAction withOriginalCommand(String originalCommand) {
        this.setOriginalCommand(originalCommand);
        return this;
    }

    public void setJsVariables(Map<String, Object> jsVariables) {
        this.jsVariables = jsVariables;
    }

    public GalenPageActionCheck withJsVariables(Map<String, Object> jsVariables) {
        this.setJsVariables(jsVariables);
        return this;
    }
}

