/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import com.galenframework.parser.SyntaxException;
import java.util.Arrays;
import java.util.List;

public enum Side {
    LEFT,
    RIGHT,
    TOP,
    BOTTOM;


    public static Side fromString(String side) {
        if ("left".equals(side)) {
            return LEFT;
        }
        if ("right".equals(side)) {
            return RIGHT;
        }
        if ("top".equals(side)) {
            return TOP;
        }
        if ("bottom".equals(side)) {
            return BOTTOM;
        }
        throw new SyntaxException(String.format("Unknown side: \"%s\"", side));
    }

    public String toString() {
        switch (this) {
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
            case TOP: {
                return "top";
            }
            case BOTTOM: {
                return "bottom";
            }
        }
        return "unknown side";
    }

    public static List<Side> sides(Side ... sides) {
        return Arrays.asList(sides);
    }
}

