/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.specs;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RangeValue {
    private int value;
    private int precision = 0;

    public RangeValue(int value) {
        this.value = value;
    }

    public RangeValue(int value, int precision) {
        this.value = value;
        this.precision = precision;
    }

    public RangeValue(double value, int precision) {
        this.value = RangeValue.convertValue(value, precision);
        this.precision = precision;
    }

    private static int convertValue(double value, int precision) {
        if (value > 0.0) {
            return (int)Math.floor(value * Math.pow(10.0, precision));
        }
        return (int)Math.ceil(value * Math.pow(10.0, precision));
    }

    public int asInt() {
        if (this.value > 0) {
            return (int)Math.floor((double)this.value / Math.pow(10.0, this.precision));
        }
        return (int)Math.ceil((double)this.value / Math.pow(10.0, this.precision));
    }

    public double asDouble() {
        return (double)this.value / Math.pow(10.0, this.precision);
    }

    public String toString() {
        if (this.precision > 0) {
            int d = (int)Math.pow(10.0, this.precision);
            int firstPart = (int)Math.floor(this.value / d);
            int secondPart = Math.abs(this.value % d);
            StringBuilder builder = new StringBuilder();
            builder.append(Integer.toString(firstPart));
            builder.append('.');
            String digits = Integer.toString(secondPart);
            for (int i = digits.length(); i < this.precision; ++i) {
                builder.append('0');
            }
            builder.append(digits);
            return builder.toString();
        }
        return Integer.toString(this.value);
    }

    public boolean equalsTo(int otherValue) {
        return this.value == RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean equalsTo(double otherValue) {
        return this.value == RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean isLessThanOrEquals(int otherValue) {
        return this.value <= RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean isLessThanOrEquals(double otherValue) {
        return this.value <= RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean isLessThan(double otherValue) {
        return this.value < RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean isGreaterThan(double otherValue) {
        return this.value > RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean isGreaterThanOrEquals(int otherValue) {
        return this.value >= RangeValue.convertValue(otherValue, this.precision);
    }

    public boolean isGreaterThanOrEquals(double otherValue) {
        return this.value >= RangeValue.convertValue(otherValue, this.precision);
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 19).append(this.value).append(this.precision).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RangeValue)) {
            return false;
        }
        RangeValue rhs = (RangeValue)obj;
        return new EqualsBuilder().append(this.value, rhs.value).append(this.precision, rhs.precision).isEquals();
    }

    public int getPrecision() {
        return this.precision;
    }

    public static RangeValue parseRangeValue(String text) {
        int pointIndex = text.indexOf(46);
        if (pointIndex > 0) {
            String firstPart = text.substring(0, pointIndex).trim();
            String secondPart = text.substring(pointIndex + 1).trim();
            int precision = secondPart.length();
            int power = (int)Math.pow(10.0, precision);
            int mainValue = Integer.parseInt(firstPart) * power;
            int addedValue = Integer.parseInt(secondPart);
            if (mainValue >= 0) {
                return new RangeValue(mainValue + addedValue, precision);
            }
            return new RangeValue(mainValue - addedValue, precision);
        }
        return new RangeValue(Integer.parseInt(text));
    }
}

