/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SingleWordSpecProcessor;
import com.galenframework.speclang2.specs.SpecAlignedProcessor;
import com.galenframework.speclang2.specs.SpecCenteredProcessor;
import com.galenframework.speclang2.specs.SpecColorSchemeProcessor;
import com.galenframework.speclang2.specs.SpecComponentProcessor;
import com.galenframework.speclang2.specs.SpecContainsProcessor;
import com.galenframework.speclang2.specs.SpecCountProcessor;
import com.galenframework.speclang2.specs.SpecCssProcessor;
import com.galenframework.speclang2.specs.SpecImageProcessor;
import com.galenframework.speclang2.specs.SpecInsideProcessor;
import com.galenframework.speclang2.specs.SpecNearProcessor;
import com.galenframework.speclang2.specs.SpecOnProcessor;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.speclang2.specs.SpecTextProcessor;
import com.galenframework.speclang2.specs.SpecWithObjectAndRangeProcessor;
import com.galenframework.speclang2.specs.SpecWithRangeProcessor;
import com.galenframework.specs.Range;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecAbove;
import com.galenframework.specs.SpecAbsent;
import com.galenframework.specs.SpecBelow;
import com.galenframework.specs.SpecHeight;
import com.galenframework.specs.SpecLeftOf;
import com.galenframework.specs.SpecRightOf;
import com.galenframework.specs.SpecVisible;
import com.galenframework.specs.SpecWidth;
import java.util.HashMap;
import java.util.Map;

public class SpecReader {
    public static Map<String, SpecProcessor> specProcessors = SpecReader.initSpecProcessors();

    public SpecReader() {
        SpecReader.initSpecProcessors();
    }

    private static Map<String, SpecProcessor> initSpecProcessors() {
        return new HashMap<String, SpecProcessor>(){
            {
                this.put("inside", new SpecInsideProcessor());
                this.put("contains", new SpecContainsProcessor());
                this.put("near", new SpecNearProcessor());
                this.put("aligned", new SpecAlignedProcessor());
                this.put("absent", new SingleWordSpecProcessor(){

                    @Override
                    public Spec createSpec() {
                        return new SpecAbsent();
                    }
                });
                this.put("visible", new SingleWordSpecProcessor(){

                    @Override
                    public Spec createSpec() {
                        return new SpecVisible();
                    }
                });
                this.put("width", new SpecWithRangeProcessor(){

                    @Override
                    public Spec createSpec(Range range) {
                        return new SpecWidth(range);
                    }
                });
                this.put("height", new SpecWithRangeProcessor(){

                    @Override
                    public Spec createSpec(Range range) {
                        return new SpecHeight(range);
                    }
                });
                this.put("text", new SpecTextProcessor());
                this.put("css", new SpecCssProcessor());
                this.put("above", new SpecWithObjectAndRangeProcessor(){

                    @Override
                    public Spec createSpec(String objectName, Range range) {
                        return new SpecAbove(objectName, range);
                    }
                });
                this.put("below", new SpecWithObjectAndRangeProcessor(){

                    @Override
                    public Spec createSpec(String objectName, Range range) {
                        return new SpecBelow(objectName, range);
                    }
                });
                this.put("left-of", new SpecWithObjectAndRangeProcessor(){

                    @Override
                    public Spec createSpec(String objectName, Range range) {
                        return new SpecLeftOf(objectName, range);
                    }
                });
                this.put("right-of", new SpecWithObjectAndRangeProcessor(){

                    @Override
                    public Spec createSpec(String objectName, Range range) {
                        return new SpecRightOf(objectName, range);
                    }
                });
                this.put("centered", new SpecCenteredProcessor());
                this.put("on", new SpecOnProcessor());
                this.put("color-scheme", new SpecColorSchemeProcessor());
                this.put("image", new SpecImageProcessor());
                this.put("component", new SpecComponentProcessor());
                this.put("count", new SpecCountProcessor());
            }
        };
    }

    public Spec read(String specText, String contextPath) {
        if (specText == null) {
            throw new IllegalArgumentException("specText argument should not be null");
        }
        if ((specText = specText.trim()).isEmpty()) {
            throw new IllegalArgumentException("specText should not be empty");
        }
        StringCharReader reader = new StringCharReader(specText);
        String firstWord = reader.readWord();
        SpecProcessor specProcessor = specProcessors.get(firstWord);
        if (specProcessor != null) {
            Spec spec = specProcessor.process(reader, contextPath);
            spec.setOriginalText(specText);
            if (reader.hasMoreNormalSymbols()) {
                throw new SyntaxException("Couldn't process: " + reader.getTheRest());
            }
            return spec;
        }
        throw new SyntaxException("Unknown spec: " + firstWord);
    }

    public Spec read(String specText) {
        return this.read(specText, null);
    }
}

