/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.config.GalenConfig;
import com.galenframework.page.Rect;
import com.galenframework.parser.ExpectColorRanges;
import com.galenframework.parser.ExpectNumber;
import com.galenframework.parser.ExpectWord;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.rainbow4j.ImageHandler;
import com.galenframework.rainbow4j.Rainbow4J;
import com.galenframework.rainbow4j.colorscheme.ColorClassifier;
import com.galenframework.rainbow4j.filters.BlurFilter;
import com.galenframework.rainbow4j.filters.ContrastFilter;
import com.galenframework.rainbow4j.filters.DenoiseFilter;
import com.galenframework.rainbow4j.filters.ImageFilter;
import com.galenframework.rainbow4j.filters.MaskFilter;
import com.galenframework.rainbow4j.filters.QuantinizeFilter;
import com.galenframework.rainbow4j.filters.ReplaceColorsDefinition;
import com.galenframework.rainbow4j.filters.ReplaceColorsFilter;
import com.galenframework.rainbow4j.filters.SaturationFilter;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecImage;
import com.galenframework.utils.GalenUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SpecImageProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        List<Pair<String, String>> parameters = Expectations.commaSeparatedRepeatedKeyValues().read(reader);
        SpecImage spec = new SpecImage();
        spec.setImagePaths(new LinkedList<String>());
        spec.setStretch(false);
        spec.setErrorRate(GalenConfig.getConfig().getImageSpecDefaultErrorRate());
        spec.setTolerance(GalenConfig.getConfig().getImageSpecDefaultTolerance());
        for (Pair<String, String> parameter : parameters) {
            ImageFilter filter;
            if ("file".equals(parameter.getKey())) {
                if (contextPath != null) {
                    spec.getImagePaths().add(contextPath + File.separator + (String)parameter.getValue());
                    continue;
                }
                spec.getImagePaths().add((String)parameter.getValue());
                continue;
            }
            if ("error".equals(parameter.getKey())) {
                spec.setErrorRate(SpecImage.ErrorRate.fromString((String)parameter.getValue()));
                continue;
            }
            if ("tolerance".equals(parameter.getKey())) {
                spec.setTolerance(this.parseIntegerParameter("tolerance", (String)parameter.getValue()));
                continue;
            }
            if ("analyze-offset".equals(parameter.getKey())) {
                spec.setAnalyzeOffset(this.parseIntegerParameter("analyze-offset", (String)parameter.getValue()));
                continue;
            }
            if ("stretch".equals(parameter.getKey())) {
                spec.setStretch(true);
                continue;
            }
            if ("area".equals(parameter.getKey())) {
                spec.setSelectedArea(this.parseRect((String)parameter.getValue()));
                continue;
            }
            if ("filter".equals(parameter.getKey())) {
                filter = this.parseImageFilter((String)parameter.getValue(), contextPath);
                spec.getOriginalFilters().add(filter);
                spec.getSampleFilters().add(filter);
                continue;
            }
            if ("filter-a".equals(parameter.getKey())) {
                filter = this.parseImageFilter((String)parameter.getValue(), contextPath);
                spec.getOriginalFilters().add(filter);
                continue;
            }
            if ("filter-b".equals(parameter.getKey())) {
                filter = this.parseImageFilter((String)parameter.getValue(), contextPath);
                spec.getSampleFilters().add(filter);
                continue;
            }
            if ("map-filter".equals(parameter.getKey())) {
                filter = this.parseImageFilter((String)parameter.getValue(), contextPath);
                spec.getMapFilters().add(filter);
                continue;
            }
            if ("crop-if-outside".equals(parameter.getKey())) {
                spec.setCropIfOutside(true);
                continue;
            }
            if ("ignore-objects".equals(parameter.getKey())) {
                String ignoreObjects = this.parseExcludeObjects((String)parameter.getValue());
                if (spec.getIgnoredObjectExpressions() == null) {
                    spec.setIgnoredObjectExpressions(new LinkedList<String>());
                }
                spec.getIgnoredObjectExpressions().add(ignoreObjects);
                continue;
            }
            throw new SyntaxException("Unknown parameter: " + (String)parameter.getKey());
        }
        if (spec.getImagePaths() == null || spec.getImagePaths().size() == 0) {
            throw new SyntaxException("There are no images defined");
        }
        return spec;
    }

    private String parseExcludeObjects(String value) {
        if (value.startsWith("[") && value.endsWith("]")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private Integer parseIntegerParameter(String name, String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        throw new SyntaxException(name + " parameter should be integer: " + value);
    }

    private ImageFilter parseImageFilter(String filterText, String contextPath) {
        StringCharReader reader = new StringCharReader(filterText);
        String filterName = new ExpectWord().read(reader);
        if ("mask".equals(filterName)) {
            return this.parseMaskFilter(contextPath, reader);
        }
        if ("replace-colors".equals(filterName)) {
            return this.parseReplaceColorsFilter(reader);
        }
        return this.parseSimpleFilter(reader, filterName);
    }

    private ImageFilter parseReplaceColorsFilter(StringCharReader reader) {
        LinkedList<ColorClassifier> classifiers = new LinkedList<ColorClassifier>();
        Color replaceColor = null;
        int tolerance = 50;
        int radius = 1;
        while (reader.hasMore()) {
            String word = reader.readWord();
            if ("with".equals(word)) {
                replaceColor = ExpectColorRanges.parseColor(reader.readWord());
                continue;
            }
            if ("tolerance".equals(word)) {
                tolerance = this.parseInt(reader);
                continue;
            }
            if ("radius".equals(word)) {
                radius = this.parseInt(reader);
                continue;
            }
            classifiers.add(ExpectColorRanges.parseColorClassifier(word));
        }
        if (replaceColor == null) {
            throw new SyntaxException("Replace color was not specified");
        }
        ReplaceColorsDefinition colorDefinition = new ReplaceColorsDefinition(replaceColor, classifiers);
        colorDefinition.setTolerance(tolerance);
        colorDefinition.setRadius(radius);
        return new ReplaceColorsFilter(Collections.singletonList(colorDefinition));
    }

    private int parseInt(StringCharReader reader) {
        Double value = Expectations.number().read(reader);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    private ImageFilter parseSimpleFilter(StringCharReader reader, String filterName) {
        Double value = new ExpectNumber().read(reader);
        if ("contrast".equals(filterName)) {
            return new ContrastFilter(value.intValue());
        }
        if ("blur".equals(filterName)) {
            return new BlurFilter(value.intValue());
        }
        if ("denoise".equals(filterName)) {
            return new DenoiseFilter(value.intValue());
        }
        if ("saturation".equals(filterName)) {
            return new SaturationFilter(value.intValue());
        }
        if ("quantinize".equals(filterName)) {
            return new QuantinizeFilter(value.intValue());
        }
        throw new SyntaxException("Unknown image filter: " + filterName);
    }

    private ImageFilter parseMaskFilter(String contextPath, StringCharReader reader) {
        String imagePath = reader.getTheRest().trim();
        if (imagePath.isEmpty()) {
            throw new SyntaxException("Mask filter image path is not defined");
        }
        String fullImagePath = imagePath;
        if (contextPath != null && !contextPath.isEmpty()) {
            fullImagePath = contextPath + File.separator + imagePath;
        }
        try {
            InputStream stream = GalenUtils.findMandatoryFileOrResourceAsStream(fullImagePath);
            return new MaskFilter(new ImageHandler(Rainbow4J.loadImage((InputStream)stream)));
        }
        catch (IOException exception) {
            throw new SyntaxException("Couldn't load " + fullImagePath, (Throwable)exception);
        }
    }

    private Rect parseRect(String text) {
        Integer[] numbers = new Integer[4];
        StringCharReader reader = new StringCharReader(text);
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = new ExpectNumber().read(reader).intValue();
        }
        return new Rect(numbers);
    }
}

