/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecComponent;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SpecComponentProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        SpecComponent spec = new SpecComponent();
        int initialPosition = reader.currentCursorPosition();
        if (reader.readWord().equals("frame")) {
            spec.setFrame(true);
        } else {
            reader.moveCursorTo(initialPosition);
        }
        String filePath = reader.readSafeUntilSymbol(',').trim();
        List<Pair<String, String>> unprocessedArguments = Expectations.commaSeparatedRepeatedKeyValues().read(reader);
        spec.setArguments(this.processArguments(unprocessedArguments));
        if (contextPath != null && !contextPath.equals(".")) {
            filePath = contextPath + File.separator + filePath;
        }
        spec.setSpecPath(filePath);
        return spec;
    }

    private Map<String, Object> processArguments(List<Pair<String, String>> unprocessedArguments) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (Pair<String, String> textArgument : unprocessedArguments) {
            arguments.put((String)textArgument.getKey(), this.processArgumentValue((String)textArgument.getValue()));
        }
        return arguments;
    }

    private Object processArgumentValue(String value) {
        try {
            if (value == null) {
                return "";
            }
            if (NumberUtils.isDigits((String)value)) {
                return Long.parseLong(value);
            }
            if (NumberUtils.isNumber((String)value)) {
                return Double.parseDouble(value);
            }
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            return value;
        }
        catch (Exception ex) {
            return value;
        }
    }
}

