/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecCentered;

public class SpecCenteredProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        SpecCentered.Alignment alignment = SpecCentered.Alignment.ALL;
        SpecCentered.Location location = null;
        String word = reader.readWord();
        if (word.isEmpty()) {
            throw new SyntaxException("Missing location and alignment");
        }
        if (SpecCentered.Location.isValid(word)) {
            location = SpecCentered.Location.fromString(word);
        } else {
            alignment = SpecCentered.Alignment.fromString(word);
            String locationWord = reader.readWord();
            if (locationWord.isEmpty()) {
                throw new SyntaxException("Missing location (on, inside)");
            }
            location = SpecCentered.Location.fromString(locationWord);
        }
        String object = reader.readWord();
        if (object.isEmpty()) {
            throw new SyntaxException("Missing object name");
        }
        int errorRate = 2;
        if (reader.hasMore()) {
            errorRate = Expectations.errorRate().read(reader);
        }
        return new SpecCentered(object, alignment, location).withErrorRate(errorRate);
    }
}

