/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.specs;

import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.specs.SpecProcessor;
import com.galenframework.specs.Alignment;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecHorizontally;
import com.galenframework.specs.SpecVertically;

public class SpecAlignedProcessor
implements SpecProcessor {
    @Override
    public Spec process(StringCharReader reader, String contextPath) {
        boolean vertically;
        String direction = reader.readWord();
        if (direction.equals("vertically")) {
            vertically = true;
        } else if (direction.equals("horizontally")) {
            vertically = false;
        } else {
            throw new SyntaxException("Incorrect alignment direction. Expected 'vertically' or 'horizontally' but got: " + direction);
        }
        String side = reader.readWord();
        Alignment alignment = Alignment.parse(side);
        String objectName = reader.readWord();
        if (objectName.isEmpty()) {
            throw new SyntaxException("Missing object name");
        }
        int errorRate = 0;
        if (reader.hasMore()) {
            errorRate = Expectations.errorRate().read(reader);
        }
        if (vertically) {
            return this.createVerticalSpec(objectName, alignment, errorRate);
        }
        return this.createHorizontalSpec(objectName, alignment, errorRate);
    }

    private Spec createVerticalSpec(String objectName, Alignment alignment, int errorRate) {
        if (!alignment.isOneOf(Alignment.CENTERED, Alignment.ALL, Alignment.LEFT, Alignment.RIGHT)) {
            throw new SyntaxException("Incorrect side for vertical alignment: " + alignment.toString());
        }
        SpecVertically spec = new SpecVertically(alignment, objectName);
        spec.setErrorRate(errorRate);
        return spec;
    }

    private Spec createHorizontalSpec(String objectName, Alignment alignment, int errorRate) {
        if (!alignment.isOneOf(Alignment.CENTERED, Alignment.ALL, Alignment.TOP, Alignment.BOTTOM)) {
            throw new SyntaxException("Incorrect side for horizontal alignment: " + alignment.toString());
        }
        SpecHorizontally spec = new SpecHorizontally(alignment, objectName);
        spec.setErrorRate(errorRate);
        return spec;
    }
}

